/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.fabric;

import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ZooKeeperGroupFactory;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.UUID;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.InitialStateDiscoveryListener;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.discovery.zen.publish.PublishClusterStateAction;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricDiscovery
extends AbstractLifecycleComponent<Discovery>
implements Discovery,
DiscoveryNodesProvider,
ServiceTrackerCustomizer<CuratorFramework, CuratorFramework>,
PublishClusterStateAction.NewClusterStateListener,
GroupListener<ESNode> {
    private static final Logger LOG = LoggerFactory.getLogger(FabricDiscovery.class);
    protected final ClusterName clusterName;
    protected final ThreadPool threadPool;
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final NodeSettingsService nodeSettingsService;
    protected final DiscoveryNodeService discoveryNodeService;
    protected final BundleContext context;
    protected final ServiceTracker<CuratorFramework, CuratorFramework> tracker;
    private DiscoveryNode localNode;
    private final CopyOnWriteArrayList<InitialStateDiscoveryListener> initialStateListeners = new CopyOnWriteArrayList();
    @Nullable
    private NodeService nodeService;
    private AllocationService allocationService;
    private volatile DiscoveryNodes latestDiscoNodes;
    private final PublishClusterStateAction publishClusterState;
    private volatile Group<ESNode> singleton;
    private final AtomicBoolean initialStateSent = new AtomicBoolean();

    @Inject
    public FabricDiscovery(Settings settings, ClusterName clusterName, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, NodeSettingsService nodeSettingsService, DiscoveryNodeService discoveryNodeService) {
        super(settings);
        this.clusterName = clusterName;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.nodeSettingsService = nodeSettingsService;
        this.discoveryNodeService = discoveryNodeService;
        this.publishClusterState = new PublishClusterStateAction(settings, transportService, this, this);
        this.context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.tracker = new ServiceTracker(this.context, CuratorFramework.class.getName(), (ServiceTrackerCustomizer)this);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        Map<String, String> nodeAttributes = this.discoveryNodeService.buildAttributes();
        String nodeId = UUID.randomBase64UUID();
        String host = this.settings.get("discovery.publish.host");
        String port = this.settings.get("discovery.publish.port");
        if (host != null && port != null) {
            InetSocketTransportAddress address = new InetSocketTransportAddress(host, Integer.parseInt(port));
            this.localNode = new DiscoveryNode(this.settings.get("name"), nodeId, address, nodeAttributes);
        } else {
            this.localNode = new DiscoveryNode(this.settings.get("name"), nodeId, this.transportService.boundAddress().publishAddress(), nodeAttributes);
        }
        this.tracker.open();
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.tracker.close();
        this.initialStateSent.set(false);
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.publishClusterState.close();
    }

    @Override
    public DiscoveryNode localNode() {
        return this.localNode;
    }

    @Override
    public void addListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.add(listener);
    }

    @Override
    public void removeListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.remove(listener);
    }

    @Override
    public String nodeDescription() {
        return this.clusterName.value() + "/" + this.localNode.id();
    }

    @Override
    public void setNodeService(@Nullable NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void setAllocationService(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    @Override
    public void publish(ClusterState clusterState) {
        if (!this.singleton.isMaster()) {
            throw new ElasticSearchIllegalStateException("Shouldn't publish state when not master");
        }
        this.latestDiscoNodes = clusterState.nodes();
        this.publishClusterState.publish(clusterState);
    }

    @Override
    public DiscoveryNodes nodes() {
        DiscoveryNodes latestNodes = this.latestDiscoNodes;
        if (latestNodes != null) {
            return latestNodes;
        }
        return DiscoveryNodes.newNodesBuilder().put(this.localNode).localNodeId(this.localNode.id()).build();
    }

    @Override
    public NodeService nodeService() {
        return this.nodeService;
    }

    public CuratorFramework addingService(ServiceReference<CuratorFramework> reference) {
        CuratorFramework curator = (CuratorFramework)this.context.getService(reference);
        try {
            ZooKeeperGroupFactory factory = new ZooKeeperGroupFactory(curator);
            this.singleton = factory.createGroup("/fabric/registry/clusters/elasticsearch/" + this.clusterName.value(), ESNode.class);
            this.singleton.add((GroupListener)this);
            this.singleton.update((NodeState)new ESNode(this.clusterName.value(), this.localNode, false));
            this.singleton.start();
        }
        catch (Exception e) {
            LOG.error("Error starting group", (Throwable)e);
        }
        return curator;
    }

    public void modifiedService(ServiceReference<CuratorFramework> reference, CuratorFramework service) {
    }

    public void removedService(ServiceReference<CuratorFramework> reference, CuratorFramework service) {
        try {
            this.singleton.close();
        }
        catch (IOException e) {
            LOG.error("Error stopping group", (Throwable)e);
        }
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void groupEvent(Group<ESNode> group, GroupListener.GroupEvent event) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(FabricDiscovery.class.getClassLoader());
            this.updateCluster();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private void updateCluster() {
        try {
            this.singleton.update((NodeState)new ESNode(this.clusterName.value(), this.localNode, this.singleton.isMaster()));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.singleton.isMaster()) {
            this.clusterService.submitStateUpdateTask("fabric-discovery", new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ClusterState.Builder stateBuilder = ClusterState.newClusterStateBuilder().state(currentState);
                    DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.newNodesBuilder().localNodeId(FabricDiscovery.this.localNode.id()).masterNodeId(((ESNode)FabricDiscovery.this.singleton.master()).getNode().id()).put(((ESNode)FabricDiscovery.this.singleton.master()).getNode());
                    for (Object node : FabricDiscovery.this.singleton.slaves()) {
                        nodesBuilder.put(((ESNode)((Object)node)).getNode());
                    }
                    FabricDiscovery.this.latestDiscoNodes = nodesBuilder.build();
                    stateBuilder.nodes(FabricDiscovery.this.latestDiscoNodes);
                    for (Object node : FabricDiscovery.this.latestDiscoNodes) {
                        if (currentState.nodes().nodeExists(((DiscoveryNode)node).id())) continue;
                        FabricDiscovery.this.transportService.connectToNode((DiscoveryNode)node);
                    }
                    if (!FabricDiscovery.this.localNode().id().equals(currentState.nodes().masterNodeId())) {
                        ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(Discovery.NO_MASTER_BLOCK).build();
                        stateBuilder.blocks(clusterBlocks);
                    }
                    return stateBuilder.build();
                }

                @Override
                public void clusterStateProcessed(ClusterState clusterState) {
                    FabricDiscovery.this.sendInitialStateEventIfNeeded();
                }
            });
        } else if (this.singleton.master() != null) {
            DiscoveryNode masterNode = ((ESNode)this.singleton.master()).getNode();
            try {
                this.transportService.connectToNode(masterNode);
            }
            catch (Exception e) {
                this.logger.warn("failed to connect to master [{}], retrying...", e, masterNode);
            }
        }
    }

    @Override
    public void onNewClusterState(final ClusterState newState) {
        if (this.singleton.isMaster()) {
            this.logger.warn("master should not receive new cluster state from [{}]", newState.nodes().masterNode());
        } else if (newState.nodes().localNode() == null) {
            this.logger.warn("received a cluster state from [{}] and not part of the cluster, should not happen", newState.nodes().masterNode());
        } else {
            this.clusterService.submitStateUpdateTask("zen-disco-receive(from master [" + newState.nodes().masterNode() + "])", new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    FabricDiscovery.this.latestDiscoNodes = newState.nodes();
                    ClusterState.Builder builder = ClusterState.builder().state(newState);
                    if (newState.routingTable().version() == currentState.routingTable().version()) {
                        builder.routingTable(currentState.routingTable());
                    }
                    if (newState.metaData().version() == currentState.metaData().version()) {
                        builder.metaData(currentState.metaData());
                    } else {
                        MetaData.Builder metaDataBuilder = MetaData.builder().metaData(newState.metaData()).removeAllIndices();
                        for (IndexMetaData indexMetaData : newState.metaData()) {
                            IndexMetaData currentIndexMetaData = currentState.metaData().index(indexMetaData.index());
                            if (currentIndexMetaData == null || currentIndexMetaData.version() != indexMetaData.version()) {
                                metaDataBuilder.put(indexMetaData, false);
                                continue;
                            }
                            metaDataBuilder.put(currentIndexMetaData, false);
                        }
                        builder.metaData(metaDataBuilder);
                    }
                    return builder.build();
                }

                @Override
                public void clusterStateProcessed(ClusterState clusterState) {
                    FabricDiscovery.this.sendInitialStateEventIfNeeded();
                }
            });
        }
    }

    private void sendInitialStateEventIfNeeded() {
        if (this.initialStateSent.compareAndSet(false, true)) {
            for (InitialStateDiscoveryListener listener : this.initialStateListeners) {
                listener.initialStateProcessed();
            }
        }
    }

    static class NodeDeserializer
    extends JsonDeserializer<ESNode> {
        NodeDeserializer() {
        }

        public ESNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                Map map = (Map)jp.readValueAs(Map.class);
                String id = map.get("id").toString();
                DiscoveryNode node = (DiscoveryNode)Base64.decodeToObject(map.get("binary").toString(), 0, DiscoveryNode.class.getClassLoader());
                return new ESNode(id, node, false);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class NodeSerializer
    extends JsonSerializer<ESNode> {
        NodeSerializer() {
        }

        public void serialize(ESNode value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField("id", value.getId());
            jgen.writeStringField("agent", System.getProperty("karaf.name"));
            if (value.isMaster()) {
                jgen.writeArrayFieldStart("services");
                jgen.writeString("elasticsearch");
                jgen.writeEndArray();
            }
            jgen.writeStringField("nodeName", value.getNode().name());
            jgen.writeStringField("nodeId", value.getNode().id());
            jgen.writeStringField("address", value.getNode().address().toString());
            jgen.writeStringField("version", value.getNode().version().toString());
            jgen.writeFieldName("attributes");
            jgen.writeStartObject();
            for (Map.Entry entry : value.getNode().attributes().entrySet()) {
                jgen.writeStringField((String)entry.getKey(), (String)entry.getValue());
            }
            jgen.writeEndObject();
            jgen.writeStringField("binary", Base64.encodeObject(value.getNode()));
            jgen.writeEndObject();
        }
    }

    @JsonSerialize(using=NodeSerializer.class)
    @JsonDeserialize(using=NodeDeserializer.class)
    static class ESNode
    extends NodeState {
        private final DiscoveryNode node;
        private final boolean master;

        ESNode(String id, DiscoveryNode node, boolean master) {
            super(id, node.getName());
            this.node = node;
            this.master = master;
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public boolean isMaster() {
            return this.master;
        }
    }
}

