/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.path.PathTrie;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.support.RestUtils;

public class RestController
extends AbstractLifecycleComponent<RestController> {
    private final PathTrie<RestHandler> getHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> postHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> putHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> deleteHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> headHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> optionsHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final RestHandlerFilter handlerFilter = new RestHandlerFilter();
    private RestFilter[] filters = new RestFilter[0];

    @Inject
    public RestController(Settings settings) {
        super(settings);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
    }

    @Override
    protected void doStop() throws ElasticSearchException {
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        for (RestFilter filter : this.filters) {
            filter.close();
        }
    }

    public synchronized void registerFilter(RestFilter preProcessor) {
        RestFilter[] copy = new RestFilter[this.filters.length + 1];
        System.arraycopy(this.filters, 0, copy, 0, this.filters.length);
        copy[this.filters.length] = preProcessor;
        Arrays.sort(copy, new Comparator<RestFilter>(){

            @Override
            public int compare(RestFilter o1, RestFilter o2) {
                return o2.order() - o1.order();
            }
        });
        this.filters = copy;
    }

    public void registerHandler(RestRequest.Method method, String path, RestHandler handler) {
        switch (method) {
            case GET: {
                this.getHandlers.insert(path, handler);
                break;
            }
            case DELETE: {
                this.deleteHandlers.insert(path, handler);
                break;
            }
            case POST: {
                this.postHandlers.insert(path, handler);
                break;
            }
            case PUT: {
                this.putHandlers.insert(path, handler);
                break;
            }
            case OPTIONS: {
                this.optionsHandlers.insert(path, handler);
                break;
            }
            case HEAD: {
                this.headHandlers.insert(path, handler);
                break;
            }
            default: {
                throw new ElasticSearchIllegalArgumentException("Can't handle [" + (Object)((Object)method) + "] for path [" + path + "]");
            }
        }
    }

    @Nullable
    public RestFilterChain filterChainOrNull(RestFilter executionFilter) {
        if (this.filters.length == 0) {
            return null;
        }
        return new ControllerFilterChain(executionFilter);
    }

    public RestFilterChain filterChain(RestFilter executionFilter) {
        return new ControllerFilterChain(executionFilter);
    }

    public void dispatchRequest(RestRequest request, RestChannel channel) {
        if (this.filters.length == 0) {
            try {
                this.executeHandler(request, channel);
            }
            catch (Exception e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    this.logger.error("Failed to send failure response for uri [" + request.uri() + "]", e1, new Object[0]);
                }
            }
        } else {
            ControllerFilterChain filterChain = new ControllerFilterChain(this.handlerFilter);
            filterChain.continueProcessing(request, channel);
        }
    }

    void executeHandler(RestRequest request, RestChannel channel) {
        RestHandler handler = this.getHandler(request);
        if (handler != null) {
            handler.handleRequest(request, channel);
        } else if (request.method() == RestRequest.Method.OPTIONS) {
            StringRestResponse response = new StringRestResponse(RestStatus.OK);
            channel.sendResponse(response);
        } else {
            channel.sendResponse(new StringRestResponse(RestStatus.BAD_REQUEST, "No handler found for uri [" + request.uri() + "] and method [" + (Object)((Object)request.method()) + "]"));
        }
    }

    private RestHandler getHandler(RestRequest request) {
        String path = this.getPath(request);
        RestRequest.Method method = request.method();
        if (method == RestRequest.Method.GET) {
            return this.getHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.POST) {
            return this.postHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.PUT) {
            return this.putHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.DELETE) {
            return this.deleteHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.HEAD) {
            return this.headHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.OPTIONS) {
            return this.optionsHandlers.retrieve(path, request.params());
        }
        return null;
    }

    private String getPath(RestRequest request) {
        return request.rawPath();
    }

    class RestHandlerFilter
    extends RestFilter {
        RestHandlerFilter() {
        }

        @Override
        public void process(RestRequest request, RestChannel channel, RestFilterChain filterChain) {
            RestController.this.executeHandler(request, channel);
        }
    }

    class ControllerFilterChain
    implements RestFilterChain {
        private final RestFilter executionFilter;
        private volatile int index;

        ControllerFilterChain(RestFilter executionFilter) {
            this.executionFilter = executionFilter;
        }

        @Override
        public void continueProcessing(RestRequest request, RestChannel channel) {
            try {
                int loc = this.index++;
                if (loc > RestController.this.filters.length) {
                    throw new ElasticSearchIllegalStateException("filter continueProcessing was called more than expected");
                }
                if (loc == RestController.this.filters.length) {
                    this.executionFilter.process(request, channel, this);
                } else {
                    RestFilter preProcessor = RestController.this.filters[loc];
                    preProcessor.process(request, channel, this);
                }
            }
            catch (Exception e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestController.this.logger.error("Failed to send failure response for uri [" + request.uri() + "]", e1, new Object[0]);
                }
            }
        }
    }
}

