/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.shorts;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.trove.iterator.TShortIntIterator;
import org.elasticsearch.common.trove.map.hash.TShortIntHashMap;
import org.elasticsearch.common.trove.set.hash.TShortHashSet;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.shorts.ShortFieldData;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.shorts.InternalShortTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class TermsShortFacetCollector
extends AbstractFacetCollector {
    private final FieldDataCache fieldDataCache;
    private final String indexFieldName;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int numberOfShards;
    private final FieldDataType fieldDataType;
    private ShortFieldData fieldData;
    private final StaticAggregatorValueProc aggregator;
    private final SearchScript script;

    public TermsShortFacetCollector(String facetName, String fieldName, int size, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<String> excluded, String scriptLang, String script, Map<String, Object> params) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        this.size = size;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        MapperService.SmartNameFieldMappers smartMappers = context.smartFieldMappers(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] doesn't have a type, can't run terms short facet collector on it");
        }
        if (smartMappers.explicitTypeInNameWithDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        if (smartMappers.mapper().fieldDataType() != FieldDataType.DefaultTypes.SHORT) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] is not of short type, can't run terms short facet collector on it");
        }
        this.indexFieldName = smartMappers.mapper().names().indexName();
        this.fieldDataType = smartMappers.mapper().fieldDataType();
        this.script = script != null ? context.scriptService().search(context.lookup(), scriptLang, script, params) : null;
        this.aggregator = this.script == null && excluded.isEmpty() ? new StaticAggregatorValueProc(CacheRecycler.popShortIntMap()) : new AggregatorValueProc(CacheRecycler.popShortIntMap(), excluded, this.script);
        if (allTerms) {
            try {
                for (IndexReader reader : context.searcher().subReaders()) {
                    ShortFieldData fieldData = (ShortFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
                    fieldData.forEachValue(this.aggregator);
                }
            }
            catch (Exception e) {
                throw new FacetPhaseExecutionException(facetName, "failed to load all terms", e);
            }
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (this.script != null) {
            this.script.setScorer(scorer);
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (ShortFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
        if (this.script != null) {
            this.script.setNextReader(reader);
        }
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachValueInDoc(doc, this.aggregator);
    }

    @Override
    public Facet facet() {
        TShortIntHashMap facets = this.aggregator.facets();
        if (facets.isEmpty()) {
            CacheRecycler.pushShortIntMap(facets);
            return new InternalShortTermsFacet(this.facetName, this.comparatorType, this.size, ImmutableList.<InternalShortTermsFacet.ShortEntry>of(), this.aggregator.missing(), this.aggregator.total());
        }
        if (this.size < 5000) {
            EntryPriorityQueue ordered = new EntryPriorityQueue(this.size, this.comparatorType.comparator());
            TShortIntIterator it = facets.iterator();
            while (it.hasNext()) {
                it.advance();
                ordered.insertWithOverflow(new InternalShortTermsFacet.ShortEntry(it.key(), it.value()));
            }
            InternalShortTermsFacet.ShortEntry[] list = new InternalShortTermsFacet.ShortEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalShortTermsFacet.ShortEntry)ordered.pop();
            }
            CacheRecycler.pushShortIntMap(facets);
            return new InternalShortTermsFacet(this.facetName, this.comparatorType, this.size, Arrays.asList(list), this.aggregator.missing(), this.aggregator.total());
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size);
        TShortIntIterator it = facets.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new InternalShortTermsFacet.ShortEntry(it.key(), it.value()));
        }
        CacheRecycler.pushShortIntMap(facets);
        return new InternalShortTermsFacet(this.facetName, this.comparatorType, this.size, ordered, this.aggregator.missing(), this.aggregator.total());
    }

    public static class StaticAggregatorValueProc
    implements ShortFieldData.ValueInDocProc,
    ShortFieldData.ValueProc {
        private final TShortIntHashMap facets;
        private int missing;
        private int total;

        public StaticAggregatorValueProc(TShortIntHashMap facets) {
            this.facets = facets;
        }

        @Override
        public void onValue(short value) {
            this.facets.putIfAbsent(value, 0);
        }

        @Override
        public void onValue(int docId, short value) {
            this.facets.adjustOrPutValue(value, 1, 1);
            ++this.total;
        }

        @Override
        public void onMissing(int docId) {
            ++this.missing;
        }

        public final TShortIntHashMap facets() {
            return this.facets;
        }

        public final int missing() {
            return this.missing;
        }

        public final int total() {
            return this.total;
        }
    }

    public static class AggregatorValueProc
    extends StaticAggregatorValueProc {
        private final SearchScript script;
        private final TShortHashSet excluded;

        public AggregatorValueProc(TShortIntHashMap facets, Set<String> excluded, SearchScript script) {
            super(facets);
            if (excluded == null || excluded.isEmpty()) {
                this.excluded = null;
            } else {
                this.excluded = new TShortHashSet(excluded.size());
                for (String s : excluded) {
                    this.excluded.add(Short.parseShort(s));
                }
            }
            this.script = script;
        }

        @Override
        public void onValue(int docId, short value) {
            if (this.excluded != null && this.excluded.contains(value)) {
                return;
            }
            if (this.script != null) {
                this.script.setNextDocId(docId);
                this.script.setNextVar("term", value);
                Object scriptValue = this.script.run();
                if (scriptValue == null) {
                    return;
                }
                if (scriptValue instanceof Boolean) {
                    if (!((Boolean)scriptValue).booleanValue()) {
                        return;
                    }
                } else {
                    value = ((Number)scriptValue).shortValue();
                }
            }
            super.onValue(docId, value);
        }
    }
}

