/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.commands.support;

import io.fabric8.agent.commands.support.ProfileVersionKey;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.mvn.Parser;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.internal.Objects;
import io.fabric8.utils.Base64Encoder;
import io.fabric8.utils.ChecksumUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.ops4j.pax.url.maven.commons.MavenConfiguration;
import org.ops4j.pax.url.maven.commons.MavenConfigurationImpl;
import org.ops4j.pax.url.maven.commons.MavenRepositoryURL;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.PropertyResolver;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileWatcher
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileWatcher.class);
    private ConfigurationAdmin configurationAdmin;
    private FabricService fabricService;
    private AtomicBoolean running = new AtomicBoolean(false);
    private long interval = 1000L;
    private List<String> watchURLs = new CopyOnWriteArrayList<String>();
    private AtomicInteger counter = new AtomicInteger(0);
    private Map<ProfileVersionKey, Map<String, Parser>> profileArtifacts = null;
    private Runnable fabricConfigureChangeRunnable = new Runnable(){

        @Override
        public void run() {
            LOG.debug("Fabric configuration changed so refreshing profile watcher");
            ProfileWatcher.this.counter.incrementAndGet();
        }
    };
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private boolean upload;
    private Set<String> missingChecksums = new HashSet<String>();

    @Override
    public void run() {
        LOG.debug("Profile watcher thread started");
        int oldCounter = -1;
        SortedSet<String> oldActiveProfiles = null;
        HashMap<File, Long> localChecksums = new HashMap<File, Long>();
        HashMap<File, Long> localModified = new HashMap<File, Long>();
        HashSet<Profile> refreshProfiles = new HashSet<Profile>();
        while (this.running.get() && this.watchURLs.size() > 0) {
            SortedSet<String> currentActiveProfiles = this.getCurrentActiveProfileVersions();
            if (this.profileArtifacts == null || oldCounter != this.counter.get() || oldActiveProfiles == null || !oldActiveProfiles.equals(currentActiveProfiles)) {
                oldCounter = this.counter.get();
                oldActiveProfiles = currentActiveProfiles;
                try {
                    LOG.debug("Reloading the currently active profile artifacts");
                    this.profileArtifacts = this.findProfileArifacts();
                }
                catch (Exception e) {
                    LOG.error("Failed to get profiles artifacts: " + e, (Throwable)e);
                }
            }
            for (Profile refreshProfile : refreshProfiles) {
                LOG.info("Refreshing profile: " + refreshProfile);
                refreshProfile.refresh();
            }
            refreshProfiles.clear();
            if (this.profileArtifacts != null) {
                File localRepository = this.getLocalRepository();
                Set<Map.Entry<ProfileVersionKey, Map<String, Parser>>> entries = this.profileArtifacts.entrySet();
                for (Map.Entry<ProfileVersionKey, Map<String, Parser>> entry : entries) {
                    ProfileVersionKey key = entry.getKey();
                    Map<String, Parser> artifactMap = entry.getValue();
                    Profile profile = key.getProfile();
                    Properties checksums = ProfileWatcher.findProfileChecksums(profile);
                    if (checksums == null) continue;
                    Set<Map.Entry<String, Parser>> artifactMapEntries = artifactMap.entrySet();
                    for (Map.Entry<String, Parser> artifactMapEntry : artifactMapEntries) {
                        String location = artifactMapEntry.getKey();
                        Parser parser = artifactMapEntry.getValue();
                        if (ProfileWatcher.isSnapshot(parser) || this.wildCardMatch(location)) {
                            Long localChecksum;
                            Object value = checksums.get(location);
                            Long checksum = null;
                            if (value instanceof Number) {
                                checksum = ((Number)value).longValue();
                            } else if (value instanceof String) {
                                checksum = Long.parseLong((String)value);
                            }
                            if (checksum == null) {
                                if (!this.missingChecksums.add(location)) continue;
                                LOG.warn("Could not find checksum for location " + location);
                                continue;
                            }
                            File file = new File(localRepository.getPath() + File.separator + parser.getArtifactPath());
                            if (!file.exists()) {
                                LOG.info("Ignoring file " + file.getPath() + " as it does not exist");
                                continue;
                            }
                            Long oldModfied = (Long)localModified.get(file);
                            long modified = file.lastModified();
                            if (oldModfied != null && modified == oldModfied) continue;
                            localModified.put(file, modified);
                            Long fileChecksum = ProfileWatcher.getFileChecksum(file);
                            if (fileChecksum == null || fileChecksum.equals(checksum) || (localChecksum = (Long)localChecksums.get(file)) != null && localChecksum.equals(fileChecksum)) continue;
                            localChecksums.put(file, fileChecksum);
                            LOG.info("Checksums don't match for " + location + ", container: " + checksum + " and local file: " + fileChecksum);
                            if (this.isUpload()) {
                                this.uploadFile(location, parser, file);
                            }
                            refreshProfiles.add(profile);
                            continue;
                        }
                        LOG.info("Ignoring " + location);
                    }
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException ex) {
                this.running.set(false);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Profile watcher thread stopped");
        }
    }

    public Map<ProfileVersionKey, Map<String, Parser>> getProfileArtifacts() {
        if (this.profileArtifacts == null) {
            return Collections.EMPTY_MAP;
        }
        return this.profileArtifacts;
    }

    protected void uploadFile(String bundleUrl, Parser parser, File fileToUpload) {
        URL url;
        FabricService fabric = this.getFabricService();
        String user = fabric.getZooKeeperUser();
        String password = fabric.getZookeeperPassword();
        URI uploadUri = fabric.getMavenRepoUploadURI();
        URI artifactUri = uploadUri.resolve(parser.getArtifactPath());
        try {
            url = artifactUri.toURL();
        }
        catch (MalformedURLException e) {
            LOG.warn("Failed to parse URI " + artifactUri + ". " + e, (Throwable)e);
            return;
        }
        if (fileToUpload == null) {
            return;
        }
        if (!fileToUpload.exists() || !fileToUpload.isFile()) {
            LOG.warn("Artifact file does not exist! " + fileToUpload.getAbsolutePath());
            return;
        }
        LOG.info("Uploading " + fileToUpload.getPath() + " to fabric8 maven repo: " + url + " as user: " + user);
        try {
            FileChannel in = new FileInputStream(fileToUpload).getChannel();
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Authorization", Base64Encoder.encode(user + ":" + password));
            WritableByteChannel out = Channels.newChannel(connection.getOutputStream());
            in.transferTo(0L, fileToUpload.length(), out);
            LOG.info("Uploaded  " + fileToUpload.getPath() + " to fabric8 maven repo: " + url);
        }
        catch (Exception e) {
            LOG.error("Failed to upload " + fileToUpload.getPath() + " to fabric8 maven repo: " + url + ". " + e, (Throwable)e);
        }
    }

    public static Long getFileChecksum(File file) {
        try {
            return ChecksumUtils.checksum(new FileInputStream(file));
        }
        catch (IOException e) {
            LOG.warn("Failed to get checksum of file: " + file.getAbsolutePath() + ". " + e, (Throwable)e);
            return null;
        }
    }

    public static Properties findProfileChecksums(Profile profile) {
        Properties checksums = null;
        Container[] containers = profile.getAssociatedContainers();
        if (containers != null) {
            Container container;
            Container[] arr$ = containers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (checksums = (container = arr$[i$]).getProvisionChecksums()) == null; ++i$) {
            }
        }
        return checksums;
    }

    public void add(String url) {
        boolean shouldStart;
        boolean bl = shouldStart = this.running.get() && this.watchURLs.size() == 0;
        if (!this.watchURLs.contains(url)) {
            this.watchURLs.add(url);
            this.counter.incrementAndGet();
        }
        if (shouldStart) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void remove(String url) {
        this.watchURLs.remove(url);
        this.counter.incrementAndGet();
    }

    protected SortedSet<String> getCurrentActiveProfileVersions() {
        Container[] containers;
        TreeSet<String> answer = new TreeSet<String>();
        for (Container container : containers = this.fabricService.getContainers()) {
            Profile[] profiles;
            container.getProvisionList();
            for (Profile profile : profiles = container.getProfiles()) {
                String id = profile.getId();
                String version = profile.getVersion();
                answer.add(id + "/" + version);
            }
        }
        return answer;
    }

    protected Map<ProfileVersionKey, Map<String, Parser>> findProfileArifacts() throws Exception {
        Container[] containers;
        HashMap<ProfileVersionKey, Map<String, Parser>> profileArtifacts = new HashMap<ProfileVersionKey, Map<String, Parser>>();
        for (Container container : containers = this.fabricService.getContainers()) {
            Profile[] profiles;
            container.getProvisionList();
            for (Profile profile : profiles = container.getProfiles()) {
                Profile overlay = profile.getOverlay();
                ProfileVersionKey key = new ProfileVersionKey(profile);
                if (profileArtifacts.containsKey(key)) continue;
                DownloadManager downloadManager = DownloadManagers.createDownloadManager(this.fabricService, overlay, this.executorService);
                Map<String, Parser> artifacts = AgentUtils.getProfileArtifacts(downloadManager, overlay);
                profileArtifacts.put(key, artifacts);
            }
        }
        return profileArtifacts;
    }

    public File getLocalRepository() {
        MavenRepositoryURL localRepositoryURL;
        MavenConfiguration configuration = this.retrieveMavenConfiguration();
        if (configuration != null && (localRepositoryURL = configuration.getLocalRepository()) != null) {
            return localRepositoryURL.getFile().getAbsoluteFile();
        }
        String localRepo = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
        return new File(localRepo).getAbsoluteFile();
    }

    protected MavenConfiguration retrieveMavenConfiguration() {
        MavenConfigurationImpl mavenConfiguration = null;
        try {
            Dictionary dictonary;
            Configuration configuration = this.configurationAdmin.getConfiguration("org.ops4j.pax.url.mvn");
            if (configuration != null && (dictonary = configuration.getProperties()) != null) {
                DictionaryPropertyResolver resolver = new DictionaryPropertyResolver(dictonary);
                mavenConfiguration = new MavenConfigurationImpl((PropertyResolver)resolver, "org.ops4j.pax.url.mvn");
            }
        }
        catch (IOException e) {
            LOG.error("Error retrieving maven configuration", (Throwable)e);
        }
        return mavenConfiguration;
    }

    public static boolean isSnapshot(Parser parser) {
        String version = parser.getVersion();
        return version != null && version.contains("SNAPSHOT");
    }

    protected boolean wildCardMatch(String text) {
        for (String watchURL : this.watchURLs) {
            if (!this.wildCardMatch(text, watchURL)) continue;
            return true;
        }
        return false;
    }

    public boolean wildCardMatch(String text, String pattern) {
        String[] cards;
        for (String card : cards = pattern.split("\\*")) {
            int idx = text.indexOf(card);
            if (idx == -1) {
                return false;
            }
            text = text.substring(idx + card.length());
        }
        return true;
    }

    public void start() {
        this.missingChecksums.clear();
        Objects.notNull((Object)this.fabricService, (String)"fabricService");
        this.fabricService.trackConfiguration(this.fabricConfigureChangeRunnable);
        if (this.running.compareAndSet(false, true) && this.watchURLs.size() > 0) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void stop() {
        this.missingChecksums.clear();
        if (this.fabricService != null) {
            this.fabricService.untrackConfiguration(this.fabricConfigureChangeRunnable);
        }
        this.running.set(false);
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public List<String> getWatchURLs() {
        return this.watchURLs;
    }

    public void setWatchURLs(List<String> watchURLs) {
        this.watchURLs = watchURLs;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public boolean isUpload() {
        return this.upload;
    }

    public void setUpload(boolean upload) {
        this.upload = upload;
    }
}

