/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.mvn;

import io.fabric8.agent.mvn.MavenSettings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class MavenSettingsImpl
implements MavenSettings {
    private static final Log LOGGER = LogFactory.getLog(MavenSettingsImpl.class);
    private static final String LOCAL_REPOSITORY_TAG = "localRepository";
    private static final String SERVER_TAG = "servers/server";
    private static final String PROFILE_TAG = "profiles/profile";
    private static final String REPOSITORY_TAG = "repositories/repository";
    private static final String ACTIVE_PROFILES_TAG = "activeProfiles/activeProfile";
    private static final String PROXY_TAG = "proxies/proxy";
    private static final String FALLBACK_REPOSITORIES = "http://osgi.sonatype.org/content/groups/pax-runner,http://repo1.maven.org/maven2,http://repository.ops4j.org/maven2,http://repository.springsource.com/maven/bundles/release,http://repository.springsource.com/maven/bundles/external";
    private Document m_document;
    private URL m_settingsURL;
    private final boolean m_useFallbackRepositories;
    private String m_localRepository;
    private String m_repositories;
    private Map<String, Map<String, String>> m_proxySettings;

    public MavenSettingsImpl(URL settingsURL, boolean useFallbackRepositories) {
        this.m_settingsURL = settingsURL;
        this.m_useFallbackRepositories = useFallbackRepositories;
        if (this.m_settingsURL == null) {
            this.m_settingsURL = MavenSettingsImpl.safeGetFile(System.getProperty("user.home") + "/.m2/settings.xml");
            if (this.m_settingsURL == null) {
                this.m_settingsURL = MavenSettingsImpl.safeGetFile(System.getProperty("maven.home") + "/conf/settings.xml");
                if (this.m_settingsURL == null) {
                    try {
                        this.m_settingsURL = MavenSettingsImpl.safeGetFile(System.getenv("M2_HOME") + "/conf/settings.xml");
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public MavenSettingsImpl(URL settingsURL) {
        this(settingsURL, false);
    }

    @Override
    public String getLocalRepository() {
        if (this.m_localRepository == null && (this.m_localRepository == null || this.m_localRepository.trim().length() == 0)) {
            this.m_localRepository = System.getProperty("user.home") + "/.m2/repository";
        }
        return this.m_localRepository;
    }

    @Override
    public String getRepositories() {
        if (this.m_repositories == null && this.m_useFallbackRepositories) {
            this.m_repositories = this.m_repositories == null || this.m_repositories.length() == 0 ? FALLBACK_REPOSITORIES : this.m_repositories + "," + FALLBACK_REPOSITORIES;
        }
        return this.m_repositories;
    }

    private static URL safeGetFile(String filePath) {
        File file;
        if (filePath != null && (file = new File(filePath)).exists() && file.canRead() && file.isFile()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Map<String, Map<String, String>> getProxySettings() {
        if (this.m_proxySettings == null) {
            this.m_proxySettings = new HashMap<String, Map<String, String>>();
        }
        return Collections.unmodifiableMap(this.m_proxySettings);
    }
}

