/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.client;

import java.io.ByteArrayInputStream;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import jline.Terminal;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.shell.console.jline.TerminalFactory;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.local.LocalAgentFactory;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.RuntimeSshException;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.impl.SimpleLogger;

public class Main {
    private static final String ROLE_DELIMITER = ",";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Properties shellCfg = new Properties(new File(System.getProperty("karaf.etc"), "org.apache.karaf.shell.cfg"));
        String host = shellCfg.getProperty("sshHost", "localhost");
        int port = Integer.parseInt(shellCfg.getProperty("sshPort", "8101"));
        int level = 1;
        int retryAttempts = 0;
        int retryDelay = 2;
        String user = "karaf";
        String password = null;
        StringBuilder command = new StringBuilder();
        Properties usersCfg = new Properties(new File(System.getProperty("karaf.etc"), "users.properties"));
        if (!usersCfg.isEmpty() && (password = (String)usersCfg.get(user = (String)usersCfg.keySet().iterator().next())).contains(ROLE_DELIMITER)) {
            password = password.substring(0, password.indexOf(ROLE_DELIMITER));
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-a")) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-h")) {
                    host = args[++i];
                    continue;
                }
                if (args[i].equals("-u")) {
                    user = args[++i];
                    continue;
                }
                if (args[i].equals("-v")) {
                    ++level;
                    continue;
                }
                if (args[i].equals("-r")) {
                    retryAttempts = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-p")) {
                    password = args[++i];
                    continue;
                }
                if (args[i].equals("-d")) {
                    retryDelay = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("--help")) {
                    System.out.println("Apache Karaf client");
                    System.out.println("  -a [port]     specify the port to connect to");
                    System.out.println("  -h [host]     specify the host to connect to");
                    System.out.println("  -u [user]     specify the user name");
                    System.out.println("  -p [password] specify the password (optional, if not provided, the password is prompted)");
                    System.out.println("                NB: this option is deprecated and will be removed in next Karaf version");
                    System.out.println("  --help        shows this help message");
                    System.out.println("  -v            raise verbosity");
                    System.out.println("  -r [attempts] retry connection establishment (up to attempts times)");
                    System.out.println("  -d [delay]    intra-retry delay (defaults to 2 seconds)");
                    System.out.println("  [commands]    commands to run");
                    System.out.println("If no commands are specified, the client will be put in an interactive mode");
                    System.exit(0);
                    continue;
                }
                System.err.println("Unknown option: " + args[i]);
                System.err.println("Run with --help for usage");
                System.exit(1);
                continue;
            }
            command.append(args[i]);
            command.append(' ');
        }
        SimpleLogger.setLevel(level);
        SshClient client = null;
        Terminal terminal = null;
        SshAgent agent = null;
        try {
            ClientChannel channel;
            agent = Main.startAgent(user);
            client = SshClient.setUpDefaultClient();
            client.setAgentFactory((SshAgentFactory)new LocalAgentFactory(agent));
            client.getProperties().put("SSH_AUTH_SOCK", "local");
            client.start();
            int retries = 0;
            ClientSession session = null;
            do {
                ConnectFuture future = client.connect(host, port);
                future.await();
                try {
                    session = future.getSession();
                }
                catch (RuntimeSshException ex) {
                    if (retries++ < retryAttempts) {
                        Thread.sleep(retryDelay * 1000);
                        System.out.println("retrying (attempt " + retries + ") ...");
                        continue;
                    }
                    throw ex;
                }
            } while (session == null);
            if (!((AuthFuture)session.authAgent(user).await()).isSuccess()) {
                if (password == null) {
                    Console console = System.console();
                    if (console != null) {
                        char[] readPassword = console.readPassword("Password: ", new Object[0]);
                        if (readPassword != null) {
                            password = new String(readPassword);
                        }
                    } else {
                        throw new Exception("Could not get system console");
                    }
                }
                if (!((AuthFuture)session.authPassword(user, password).await()).isSuccess()) {
                    throw new Exception("Authentication failure");
                }
            }
            if (command.length() > 0) {
                channel = session.createChannel("exec", command.append("\n").toString());
                channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
            } else {
                terminal = new TerminalFactory().getTerminal();
                channel = session.createChannel("shell");
                ConsoleInputStream in = new ConsoleInputStream(terminal.wrapInIfNeeded(System.in));
                new Thread(in).start();
                channel.setIn((InputStream)in);
                ((ChannelShell)channel).setPtyColumns(terminal != null ? terminal.getWidth() : 80);
                ((ChannelShell)channel).setupSensibleDefaultPty();
                ((ChannelShell)channel).setAgentForwarding(true);
                String ctype = System.getenv("LC_CTYPE");
                if (ctype == null) {
                    ctype = Locale.getDefault().toString() + "." + System.getProperty("input.encoding", Charset.defaultCharset().name());
                }
                ((ChannelShell)channel).setEnv("LC_CTYPE", ctype);
            }
            channel.setOut(AnsiConsole.wrapOutputStream((OutputStream)System.out));
            channel.setErr(AnsiConsole.wrapOutputStream((OutputStream)System.err));
            channel.open();
            channel.waitFor(2, 0L);
        }
        catch (Throwable t) {
            if (level > 1) {
                t.printStackTrace();
            } else {
                System.err.println(t.getMessage());
            }
            System.exit(1);
        }
        finally {
            try {
                client.stop();
            }
            catch (Throwable t) {}
            try {
                if (terminal != null) {
                    terminal.restore();
                }
            }
            catch (Throwable t) {}
        }
        System.exit(0);
    }

    protected static SshAgent startAgent(String user) {
        try {
            AgentImpl local = new AgentImpl();
            URL url = Main.class.getClassLoader().getResource("karaf.key");
            InputStream is = url.openStream();
            ObjectInputStream r = new ObjectInputStream(is);
            KeyPair keyPair = (KeyPair)r.readObject();
            local.addIdentity(keyPair, "karaf");
            return local;
        }
        catch (Throwable e) {
            System.err.println("Error starting ssh agent for: " + e.getMessage());
            return null;
        }
    }

    public static String readLine(String msg) throws IOException {
        StringBuffer sb = new StringBuffer();
        System.err.print(msg);
        System.err.flush();
        while (true) {
            int c;
            if ((c = System.in.read()) < 0) {
                return null;
            }
            System.err.print((char)c);
            if (c == 13 || c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    private static class ConsoleInputStream
    extends InputStream
    implements Runnable {
        private InputStream in;
        private boolean eof = false;
        private final BlockingQueue<Integer> queue = new ArrayBlockingQueue<Integer>(1024);

        public ConsoleInputStream(InputStream in) {
            this.in = in;
        }

        private int read(boolean wait) throws IOException {
            Integer i;
            if (this.eof && this.queue.isEmpty()) {
                return -1;
            }
            if (wait) {
                try {
                    i = this.queue.take();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            } else {
                i = (Integer)this.queue.poll();
            }
            if (i == null) {
                return -1;
            }
            return i;
        }

        public int read() throws IOException {
            return this.read(true);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int nb;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int i = this.read(true);
            if (i < 0) {
                return -1;
            }
            b[off++] = (byte)i;
            for (nb = 1; nb < len; ++nb) {
                i = this.read(false);
                if (i < 0) {
                    return nb;
                }
                b[off++] = (byte)i;
            }
            return nb;
        }

        public int available() throws IOException {
            return this.queue.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    c = this.in.read();
                    if (c == -1) {
                        this.eof = true;
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable t) {
                    this.eof = true;
                    try {
                        this.queue.put(-1);
                        return;
                    }
                    catch (InterruptedException var2_4) {
                        // empty catch block
                    }
                    return;
                }
                catch (Throwable var3_5) {
                    this.eof = true;
                    try {
                        this.queue.put(-1);
                        throw var3_5;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    throw var3_5;
                }
                try {
                    this.queue.put(-1);
                    return;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    this.queue.put(c);
                    continue;
                }
                break;
            }
        }
    }
}

