/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.scr;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.Validatable;
import io.fabric8.api.scr.ValidationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractComponent
implements Validatable {
    private static final transient Logger LOG = LoggerFactory.getLogger(AbstractComponent.class);
    private ValidationSupport active = new ValidationSupport();

    public void activateComponent() {
        this.active.setValid();
        LOG.info("activateComponent: " + this);
    }

    public void deactivateComponent() {
        LOG.info("deactivateComponent: " + this);
        this.active.setInvalid();
    }

    @Override
    public boolean isValid() {
        return this.active.isValid();
    }

    @Override
    public void assertValid() {
        this.active.assertValid();
    }
}

