/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeAlgorithm;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveMerger
extends ThreeWayMerger {
    private NameConflictTreeWalk tw;
    protected String[] commitNames;
    private static final int T_BASE = 0;
    private static final int T_OURS = 1;
    private static final int T_THEIRS = 2;
    private static final int T_INDEX = 3;
    private static final int T_FILE = 4;
    private DirCacheBuilder builder;
    protected ObjectId resultTree;
    private List<String> unmergedPaths = new ArrayList<String>();
    private List<String> modifiedFiles = new LinkedList<String>();
    private Map<String, DirCacheEntry> toBeCheckedOut = new HashMap<String, DirCacheEntry>();
    private List<String> toBeDeleted = new ArrayList<String>();
    private Map<String, MergeResult<? extends Sequence>> mergeResults = new HashMap<String, MergeResult<? extends Sequence>>();
    private Map<String, MergeFailureReason> failingPaths = new HashMap<String, MergeFailureReason>();
    private boolean enterSubtree;
    protected boolean inCore;
    protected boolean implicitDirCache;
    protected DirCache dircache;
    protected WorkingTreeIterator workingTreeIterator;
    protected MergeAlgorithm mergeAlgorithm;

    protected ResolveMerger(Repository local, boolean inCore) {
        super(local);
        DiffAlgorithm.SupportedAlgorithm diffAlg = local.getConfig().getEnum("diff", null, "algorithm", DiffAlgorithm.SupportedAlgorithm.HISTOGRAM);
        this.mergeAlgorithm = new MergeAlgorithm(DiffAlgorithm.getAlgorithm(diffAlg));
        this.commitNames = new String[]{"BASE", "OURS", "THEIRS"};
        this.inCore = inCore;
        if (inCore) {
            this.implicitDirCache = false;
            this.dircache = DirCache.newInCore();
        } else {
            this.implicitDirCache = true;
        }
    }

    protected ResolveMerger(Repository local) {
        this(local, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean mergeImpl() throws IOException {
        if (this.implicitDirCache) {
            this.dircache = this.getRepository().lockDirCache();
        }
        try {
            boolean bl = this.mergeTrees(this.mergeBase(), this.sourceTrees[0], this.sourceTrees[1]);
            return bl;
        }
        finally {
            if (this.implicitDirCache) {
                this.dircache.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkout() throws NoWorkTreeException, IOException {
        ObjectReader r = this.db.getObjectDatabase().newReader();
        try {
            File f;
            for (Map.Entry<String, DirCacheEntry> entry : this.toBeCheckedOut.entrySet()) {
                f = new File(this.db.getWorkTree(), entry.getKey());
                this.createDir(f.getParentFile());
                DirCacheCheckout.checkoutEntry(this.db, f, entry.getValue(), r);
                this.modifiedFiles.add(entry.getKey());
            }
            for (int i = this.toBeDeleted.size() - 1; i >= 0; --i) {
                String fileName = this.toBeDeleted.get(i);
                f = new File(this.db.getWorkTree(), fileName);
                if (!f.delete()) {
                    this.failingPaths.put(fileName, MergeFailureReason.COULD_NOT_DELETE);
                }
                this.modifiedFiles.add(fileName);
            }
        }
        finally {
            r.release();
        }
    }

    private void createDir(File f) throws IOException {
        if (!f.isDirectory() && !f.mkdirs()) {
            File p;
            for (p = f; p != null && !p.exists(); p = p.getParentFile()) {
            }
            if (p == null || p.isDirectory()) {
                throw new IOException(JGitText.get().cannotCreateDirectory);
            }
            FileUtils.delete(p);
            if (!f.mkdirs()) {
                throw new IOException(JGitText.get().cannotCreateDirectory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() throws NoWorkTreeException, CorruptObjectException, IOException {
        if (this.inCore) {
            this.modifiedFiles.clear();
            return;
        }
        DirCache dc = this.db.readDirCache();
        ObjectReader or = this.db.getObjectDatabase().newReader();
        Iterator<String> mpathsIt = this.modifiedFiles.iterator();
        while (mpathsIt.hasNext()) {
            String mpath = mpathsIt.next();
            DirCacheEntry entry = dc.getEntry(mpath);
            if (entry == null) continue;
            FileOutputStream fos = new FileOutputStream(new File(this.db.getWorkTree(), mpath));
            try {
                or.open(entry.getObjectId()).copyTo(fos);
            }
            finally {
                fos.close();
            }
            mpathsIt.remove();
        }
    }

    private DirCacheEntry add(byte[] path, CanonicalTreeParser p, int stage, long lastMod, long len) {
        if (p != null && !p.getEntryFileMode().equals(FileMode.TREE)) {
            DirCacheEntry e = new DirCacheEntry(path, stage);
            e.setFileMode(p.getEntryFileMode());
            e.setObjectId(p.getEntryObjectId());
            e.setLastModified(lastMod);
            e.setLength(len);
            this.builder.add(e);
            return e;
        }
        return null;
    }

    private DirCacheEntry keep(DirCacheEntry e) {
        DirCacheEntry newEntry = new DirCacheEntry(e.getPathString(), e.getStage());
        newEntry.setFileMode(e.getFileMode());
        newEntry.setObjectId(e.getObjectId());
        newEntry.setLastModified(e.getLastModified());
        newEntry.setLength(e.getLength());
        this.builder.add(newEntry);
        return newEntry;
    }

    private boolean processEntry(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, DirCacheBuildIterator index, WorkingTreeIterator work) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        this.enterSubtree = true;
        int modeO = this.tw.getRawMode(1);
        int modeT = this.tw.getRawMode(2);
        int modeB = this.tw.getRawMode(0);
        if (modeO == 0 && modeT == 0 && modeB == 0) {
            return true;
        }
        if (this.isIndexDirty()) {
            return false;
        }
        DirCacheEntry ourDce = null;
        if (index == null || index.getDirCacheEntry() == null) {
            if (ResolveMerger.nonTree(modeO)) {
                ourDce = new DirCacheEntry(this.tw.getRawPath());
                ourDce.setObjectId(this.tw.getObjectId(1));
                ourDce.setFileMode(this.tw.getFileMode(1));
            }
        } else {
            ourDce = index.getDirCacheEntry();
        }
        if (ResolveMerger.nonTree(modeO) && ResolveMerger.nonTree(modeT) && this.tw.idEqual(1, 2)) {
            if (modeO == modeT) {
                this.keep(ourDce);
                return true;
            }
            int newMode = this.mergeFileModes(modeB, modeO, modeT);
            if (newMode != FileMode.MISSING.getBits()) {
                if (newMode == modeO) {
                    this.keep(ourDce);
                } else {
                    if (this.isWorktreeDirty(work)) {
                        return false;
                    }
                    DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, 0L, 0L);
                    this.toBeCheckedOut.put(this.tw.getPathString(), e);
                }
                return true;
            }
            this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
            this.add(this.tw.getRawPath(), ours, 2, 0L, 0L);
            this.add(this.tw.getRawPath(), theirs, 3, 0L, 0L);
            this.unmergedPaths.add(this.tw.getPathString());
            this.mergeResults.put(this.tw.getPathString(), new MergeResult(Collections.emptyList()));
            return true;
        }
        if (ResolveMerger.nonTree(modeO) && modeB == modeT && this.tw.idEqual(0, 2)) {
            this.keep(ourDce);
            return true;
        }
        if (modeB == modeO && this.tw.idEqual(0, 1)) {
            if (this.isWorktreeDirty(work)) {
                return false;
            }
            if (ResolveMerger.nonTree(modeT)) {
                DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, 0L, 0L);
                if (e != null) {
                    this.toBeCheckedOut.put(this.tw.getPathString(), e);
                }
                return true;
            }
            if (modeT == 0 && modeB != 0) {
                if (this.tw.getTreeCount() > 4 && this.tw.getRawMode(4) == 0) {
                    return true;
                }
                this.toBeDeleted.add(this.tw.getPathString());
                return true;
            }
        }
        if (this.tw.isSubtree()) {
            if (ResolveMerger.nonTree(modeO) && !ResolveMerger.nonTree(modeT)) {
                if (ResolveMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
                }
                this.add(this.tw.getRawPath(), ours, 2, 0L, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (ResolveMerger.nonTree(modeT) && !ResolveMerger.nonTree(modeO)) {
                if (ResolveMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
                }
                this.add(this.tw.getRawPath(), theirs, 3, 0L, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (!ResolveMerger.nonTree(modeO)) {
                return true;
            }
        }
        if (ResolveMerger.nonTree(modeO) && ResolveMerger.nonTree(modeT)) {
            if (this.isWorktreeDirty(work)) {
                return false;
            }
            if (ResolveMerger.isGitLink(modeO) || ResolveMerger.isGitLink(modeT)) {
                this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
                this.add(this.tw.getRawPath(), ours, 2, 0L, 0L);
                this.add(this.tw.getRawPath(), theirs, 3, 0L, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            MergeResult<RawText> result = this.contentMerge(base, ours, theirs);
            File of = this.writeMergedFile(result);
            this.updateIndex(base, ours, theirs, result, of);
            if (result.containsConflicts()) {
                this.unmergedPaths.add(this.tw.getPathString());
            }
            this.modifiedFiles.add(this.tw.getPathString());
        } else if (modeO != modeT && (modeO != 0 && !this.tw.idEqual(0, 1) || modeT != 0 && !this.tw.idEqual(0, 2))) {
            this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
            this.add(this.tw.getRawPath(), ours, 2, 0L, 0L);
            DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 3, 0L, 0L);
            if (modeO == 0) {
                if (this.isWorktreeDirty(work)) {
                    return false;
                }
                if (ResolveMerger.nonTree(modeT) && e != null) {
                    this.toBeCheckedOut.put(this.tw.getPathString(), e);
                }
            }
            this.unmergedPaths.add(this.tw.getPathString());
            this.mergeResults.put(this.tw.getPathString(), this.contentMerge(base, ours, theirs));
        }
        return true;
    }

    private MergeResult<RawText> contentMerge(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs) throws IOException {
        RawText baseText = base == null ? RawText.EMPTY_TEXT : ResolveMerger.getRawText(base.getEntryObjectId(), this.db);
        RawText ourText = ours == null ? RawText.EMPTY_TEXT : ResolveMerger.getRawText(ours.getEntryObjectId(), this.db);
        RawText theirsText = theirs == null ? RawText.EMPTY_TEXT : ResolveMerger.getRawText(theirs.getEntryObjectId(), this.db);
        return this.mergeAlgorithm.merge(RawTextComparator.DEFAULT, baseText, ourText, theirsText);
    }

    private boolean isIndexDirty() {
        boolean isDirty;
        if (this.inCore) {
            return false;
        }
        int modeI = this.tw.getRawMode(3);
        int modeO = this.tw.getRawMode(1);
        boolean bl = isDirty = ResolveMerger.nonTree(modeI) && (modeO != modeI || !this.tw.idEqual(3, 1));
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), MergeFailureReason.DIRTY_INDEX);
        }
        return isDirty;
    }

    private boolean isWorktreeDirty(WorkingTreeIterator work) {
        if (work == null) {
            return false;
        }
        int modeF = this.tw.getRawMode(4);
        int modeO = this.tw.getRawMode(1);
        boolean isDirty = work.isModeDifferent(modeO);
        if (!isDirty && ResolveMerger.nonTree(modeF)) {
            boolean bl = isDirty = !this.tw.idEqual(4, 1);
        }
        if (isDirty && modeF == 16384 && modeO == 0) {
            isDirty = false;
        }
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), MergeFailureReason.DIRTY_WORKTREE);
        }
        return isDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndex(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, MergeResult<RawText> result, File of) throws FileNotFoundException, IOException {
        if (result.containsConflicts()) {
            this.add(this.tw.getRawPath(), base, 1, 0L, 0L);
            this.add(this.tw.getRawPath(), ours, 2, 0L, 0L);
            this.add(this.tw.getRawPath(), theirs, 3, 0L, 0L);
            this.mergeResults.put(this.tw.getPathString(), result);
        } else {
            DirCacheEntry dce = new DirCacheEntry(this.tw.getPathString());
            int newMode = this.mergeFileModes(this.tw.getRawMode(0), this.tw.getRawMode(1), this.tw.getRawMode(2));
            dce.setFileMode(newMode == FileMode.MISSING.getBits() ? FileMode.REGULAR_FILE : FileMode.fromBits(newMode));
            dce.setLastModified(of.lastModified());
            dce.setLength((int)of.length());
            FileInputStream is = new FileInputStream(of);
            try {
                dce.setObjectId(this.getObjectInserter().insert(3, of.length(), is));
            }
            finally {
                ((InputStream)is).close();
                if (this.inCore) {
                    FileUtils.delete(of);
                }
            }
            this.builder.add(dce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeMergedFile(MergeResult<RawText> result) throws FileNotFoundException, IOException {
        MergeFormatter fmt = new MergeFormatter();
        File of = null;
        if (!this.inCore) {
            File workTree = this.db.getWorkTree();
            if (workTree == null) {
                throw new UnsupportedOperationException();
            }
            of = new File(workTree, this.tw.getPathString());
            File parentFolder = of.getParentFile();
            if (!parentFolder.exists()) {
                parentFolder.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(of);
            try {
                fmt.formatMerge(fos, result, Arrays.asList(this.commitNames), "UTF-8");
            }
            finally {
                fos.close();
            }
        }
        if (!result.containsConflicts()) {
            of = File.createTempFile("merge_", "_temp", null);
            FileOutputStream fos = new FileOutputStream(of);
            try {
                fmt.formatMerge(fos, result, Arrays.asList(this.commitNames), "UTF-8");
            }
            finally {
                fos.close();
            }
        }
        return of;
    }

    private int mergeFileModes(int modeB, int modeO, int modeT) {
        if (modeO == modeT) {
            return modeO;
        }
        if (modeB == modeO) {
            return modeT == FileMode.MISSING.getBits() ? modeO : modeT;
        }
        if (modeB == modeT) {
            return modeO == FileMode.MISSING.getBits() ? modeT : modeO;
        }
        return FileMode.MISSING.getBits();
    }

    private static RawText getRawText(ObjectId id, Repository db) throws IOException {
        if (id.equals(ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        return new RawText(db.open(id, 3).getCachedBytes());
    }

    private static boolean nonTree(int mode) {
        return mode != 0 && !FileMode.TREE.equals(mode);
    }

    private static boolean isGitLink(int mode) {
        return FileMode.GITLINK.equals(mode);
    }

    @Override
    public ObjectId getResultTreeId() {
        return this.resultTree == null ? null : this.resultTree.toObjectId();
    }

    public void setCommitNames(String[] commitNames) {
        this.commitNames = commitNames;
    }

    public String[] getCommitNames() {
        return this.commitNames;
    }

    public List<String> getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public List<String> getModifiedFiles() {
        return this.modifiedFiles;
    }

    public Map<String, DirCacheEntry> getToBeCheckedOut() {
        return this.toBeCheckedOut;
    }

    public Map<String, MergeResult<? extends Sequence>> getMergeResults() {
        return this.mergeResults;
    }

    public Map<String, MergeFailureReason> getFailingPaths() {
        return this.failingPaths.size() == 0 ? null : this.failingPaths;
    }

    public boolean failed() {
        return this.failingPaths.size() > 0;
    }

    public void setDirCache(DirCache dc) {
        this.dircache = dc;
        this.implicitDirCache = false;
    }

    public void setWorkingTreeIterator(WorkingTreeIterator workingTreeIterator) {
        this.workingTreeIterator = workingTreeIterator;
    }

    protected boolean mergeTrees(AbstractTreeIterator baseTree, RevTree headTree, RevTree mergeTree) throws IOException {
        this.builder = this.dircache.builder();
        DirCacheBuildIterator buildIt = new DirCacheBuildIterator(this.builder);
        this.tw = new NameConflictTreeWalk(this.db);
        this.tw.addTree(baseTree);
        this.tw.addTree(headTree);
        this.tw.addTree(mergeTree);
        this.tw.addTree(buildIt);
        if (this.workingTreeIterator != null) {
            this.tw.addTree(this.workingTreeIterator);
        }
        while (this.tw.next()) {
            if (!this.processEntry(this.tw.getTree(0, CanonicalTreeParser.class), this.tw.getTree(1, CanonicalTreeParser.class), this.tw.getTree(2, CanonicalTreeParser.class), this.tw.getTree(3, DirCacheBuildIterator.class), this.workingTreeIterator == null ? null : this.tw.getTree(4, WorkingTreeIterator.class))) {
                this.cleanUp();
                return false;
            }
            if (!this.tw.isSubtree() || !this.enterSubtree) continue;
            this.tw.enterSubtree();
        }
        if (!this.inCore) {
            this.checkout();
            if (!this.builder.commit()) {
                this.cleanUp();
                throw new IndexWriteException();
            }
            this.builder = null;
        } else {
            this.builder.finish();
            this.builder = null;
        }
        if (this.getUnmergedPaths().isEmpty() && !this.failed()) {
            this.resultTree = this.dircache.writeTree(this.getObjectInserter());
            return true;
        }
        this.resultTree = null;
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MergeFailureReason {
        DIRTY_INDEX,
        DIRTY_WORKTREE,
        COULD_NOT_DELETE;

    }
}

