/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Assert {
    public static <V> V notNull(String message, V object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(message != null && message.length() > 0 ? message : "Object cannot be null");
        }
        return object;
    }

    public static <V> V notNull(V object) throws IllegalArgumentException {
        return Assert.notNull(null, object);
    }

    public static <V> V[] notEmpty(String message, V[] objects) throws IllegalArgumentException {
        if (objects.length == 0) {
            throw new IllegalArgumentException(message != null && message.length() > 0 ? message : "Objects cannot be empty");
        }
        return objects;
    }

    public static <V> V[] notEmpty(V[] objects) throws IllegalArgumentException {
        return Assert.notEmpty(null, objects);
    }

    public static String notEmpty(String message, String string) throws IllegalArgumentException {
        if (string.length() == 0) {
            throw new IllegalArgumentException(message != null && message.length() > 0 ? message : "String cannot be empty");
        }
        return string;
    }

    public static String notEmpty(String string) throws IllegalArgumentException {
        return Assert.notEmpty(null, string);
    }

    public static String formatNotNull(String prefix) {
        return prefix + " cannot be null";
    }

    public static String formatNotEmpty(String prefix) {
        return prefix + " cannot be empty";
    }
}

