/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel;

import io.fabric8.camel.MasterEndpoint;
import io.fabric8.camel.ZKComponentSupport;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class MasterComponent
extends ZKComponentSupport {
    private String zkRoot = "/fabric/registry/camel/master";

    public String getZkRoot() {
        return this.zkRoot;
    }

    public void setZkRoot(String zkRoot) {
        this.zkRoot = zkRoot;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        int idx = remaining.indexOf(58);
        if (idx <= 0) {
            throw new IllegalArgumentException("Missing : in URI so can't split the group name from the actual URI for '" + remaining + "'");
        }
        String name = remaining.substring(0, idx);
        String childUri = remaining.substring(idx + 1);
        if (params != null && params.size() > 0) {
            childUri = childUri + "?" + URISupport.createQueryString(params);
        }
        return new MasterEndpoint(uri, this, name, childUri);
    }

    protected String getFabricPath(String name) {
        String path = name;
        if (ObjectHelper.isNotEmpty((Object)this.zkRoot)) {
            path = this.zkRoot + "/" + name;
        }
        return path;
    }
}

