/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.bytebuffer;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.bytebuffer.ByteBufferFile;

public class ByteBufferIndexInput
extends IndexInput {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private final ByteBufferFile file;
    private final long length;
    private ByteBuffer currentBuffer;
    private int currentBufferIndex;
    private long bufferStart;
    private final int BUFFER_SIZE;
    private volatile boolean closed = false;

    public ByteBufferIndexInput(String name, ByteBufferFile file) throws IOException {
        super("BBIndexInput(name=" + name + ")");
        this.file = file;
        this.file.incRef();
        this.length = file.getLength();
        this.BUFFER_SIZE = file.bufferSize;
        this.currentBufferIndex = -1;
        this.currentBuffer = EMPTY_BUFFER;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.file.decRef();
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public short readShort() throws IOException {
        try {
            this.currentBuffer.mark();
            return this.currentBuffer.getShort();
        }
        catch (BufferUnderflowException e) {
            this.currentBuffer.reset();
            return super.readShort();
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            this.currentBuffer.mark();
            return this.currentBuffer.getInt();
        }
        catch (BufferUnderflowException e) {
            this.currentBuffer.reset();
            return super.readInt();
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            this.currentBuffer.mark();
            return this.currentBuffer.getLong();
        }
        catch (BufferUnderflowException e) {
            this.currentBuffer.reset();
            return super.readLong();
        }
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.currentBuffer.hasRemaining()) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer(true);
        }
        return this.currentBuffer.get();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int remainInBuffer;
            if (!this.currentBuffer.hasRemaining()) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer(true);
            }
            int bytesToCopy = len < (remainInBuffer = this.currentBuffer.remaining()) ? len : remainInBuffer;
            this.currentBuffer.get(b, offset, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
        }
    }

    @Override
    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.currentBuffer.position();
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.currentBuffer == EMPTY_BUFFER || pos < this.bufferStart || pos >= this.bufferStart + (long)this.BUFFER_SIZE) {
            this.currentBufferIndex = (int)(pos / (long)this.BUFFER_SIZE);
            this.switchCurrentBuffer(false);
        }
        try {
            this.currentBuffer.position((int)(pos % (long)this.BUFFER_SIZE));
        }
        catch (IllegalArgumentException e) {
            IOException ioException = new IOException("seeking past position");
            ioException.initCause(e);
            throw ioException;
        }
    }

    private void switchCurrentBuffer(boolean enforceEOF) throws IOException {
        if (this.currentBufferIndex >= this.file.numBuffers()) {
            if (enforceEOF) {
                throw new EOFException("Read past EOF (resource: " + this + ")");
            }
            --this.currentBufferIndex;
            this.currentBuffer.position(this.currentBuffer.limit());
        } else {
            ByteBuffer buffer = this.file.getBuffer(this.currentBufferIndex);
            this.currentBuffer = buffer.asReadOnlyBuffer();
            this.currentBuffer.position(0);
            this.bufferStart = (long)this.BUFFER_SIZE * (long)this.currentBufferIndex;
            long buflen = this.length - this.bufferStart;
            if (buflen < (long)this.BUFFER_SIZE) {
                this.currentBuffer.limit((int)buflen);
            }
            if (!this.currentBuffer.hasRemaining()) {
                if (enforceEOF) {
                    throw new EOFException("Read past EOF (resource: " + this + ")");
                }
                --this.currentBufferIndex;
                this.currentBuffer.position(this.currentBuffer.limit());
            }
        }
    }

    @Override
    public Object clone() {
        ByteBufferIndexInput cloned = (ByteBufferIndexInput)super.clone();
        cloned.file.incRef();
        if (this.currentBuffer != EMPTY_BUFFER) {
            cloned.currentBuffer = this.currentBuffer.asReadOnlyBuffer();
            cloned.currentBuffer.position(this.currentBuffer.position());
        }
        return cloned;
    }
}

