/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.health.ClusterIndexHealth;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClusterHealthResponse
extends ActionResponse
implements Iterable<ClusterIndexHealth> {
    private String clusterName;
    int numberOfNodes = 0;
    int numberOfDataNodes = 0;
    int activeShards = 0;
    int relocatingShards = 0;
    int activePrimaryShards = 0;
    int initializingShards = 0;
    int unassignedShards = 0;
    boolean timedOut = false;
    ClusterHealthStatus status = ClusterHealthStatus.RED;
    private List<String> validationFailures;
    Map<String, ClusterIndexHealth> indices = Maps.newHashMap();

    ClusterHealthResponse() {
    }

    public ClusterHealthResponse(String clusterName, List<String> validationFailures) {
        this.clusterName = clusterName;
        this.validationFailures = validationFailures;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String getClusterName() {
        return this.clusterName();
    }

    public List<String> validationFailures() {
        return this.validationFailures;
    }

    public List<String> getValidationFailures() {
        return this.validationFailures();
    }

    public List<String> allValidationFailures() {
        ArrayList<String> allFailures = Lists.newArrayList(this.validationFailures());
        for (ClusterIndexHealth indexHealth : this.indices.values()) {
            allFailures.addAll(indexHealth.validationFailures());
        }
        return allFailures;
    }

    public List<String> getAllValidationFailures() {
        return this.allValidationFailures();
    }

    public int activeShards() {
        return this.activeShards;
    }

    public int getActiveShards() {
        return this.activeShards();
    }

    public int relocatingShards() {
        return this.relocatingShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards();
    }

    public int activePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards();
    }

    public int initializingShards() {
        return this.initializingShards;
    }

    public int getInitializingShards() {
        return this.initializingShards();
    }

    public int unassignedShards() {
        return this.unassignedShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards();
    }

    public int numberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes();
    }

    public int numberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public int getNumberOfDataNodes() {
        return this.numberOfDataNodes();
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    public boolean isTimedOut() {
        return this.timedOut();
    }

    public ClusterHealthStatus status() {
        return this.status;
    }

    public ClusterHealthStatus getStatus() {
        return this.status();
    }

    public Map<String, ClusterIndexHealth> indices() {
        return this.indices;
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return this.indices();
    }

    @Override
    public Iterator<ClusterIndexHealth> iterator() {
        return this.indices.values().iterator();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        this.clusterName = in.readString();
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.numberOfNodes = in.readVInt();
        this.numberOfDataNodes = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            ClusterIndexHealth indexHealth = ClusterIndexHealth.readClusterIndexHealth(in);
            this.indices.put(indexHealth.index(), indexHealth);
        }
        this.timedOut = in.readBoolean();
        size = in.readVInt();
        if (size == 0) {
            this.validationFailures = ImmutableList.of();
        } else {
            for (i = 0; i < size; ++i) {
                this.validationFailures.add(in.readString());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.clusterName);
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeVInt(this.numberOfNodes);
        out.writeVInt(this.numberOfDataNodes);
        out.writeByte(this.status.value());
        out.writeVInt(this.indices.size());
        for (ClusterIndexHealth indexHealth : this) {
            indexHealth.writeTo(out);
        }
        out.writeBoolean(this.timedOut);
        out.writeVInt(this.validationFailures.size());
        for (String failure : this.validationFailures) {
            out.writeUTF(failure);
        }
    }
}

