/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.NodesOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class NodesStatsRequest
extends NodesOperationRequest<NodesStatsRequest> {
    private boolean indices = true;
    private boolean os;
    private boolean process;
    private boolean jvm;
    private boolean threadPool;
    private boolean network;
    private boolean fs;
    private boolean transport;
    private boolean http;

    protected NodesStatsRequest() {
    }

    public NodesStatsRequest(String ... nodesIds) {
        super(nodesIds);
    }

    public NodesStatsRequest all() {
        this.indices = true;
        this.os = true;
        this.process = true;
        this.jvm = true;
        this.threadPool = true;
        this.network = true;
        this.fs = true;
        this.transport = true;
        this.http = true;
        return this;
    }

    public NodesStatsRequest clear() {
        this.indices = false;
        this.os = false;
        this.process = false;
        this.jvm = false;
        this.threadPool = false;
        this.network = false;
        this.fs = false;
        this.transport = false;
        this.http = false;
        return this;
    }

    public boolean indices() {
        return this.indices;
    }

    public NodesStatsRequest indices(boolean indices) {
        this.indices = indices;
        return this;
    }

    public boolean os() {
        return this.os;
    }

    public NodesStatsRequest os(boolean os) {
        this.os = os;
        return this;
    }

    public boolean process() {
        return this.process;
    }

    public NodesStatsRequest process(boolean process) {
        this.process = process;
        return this;
    }

    public boolean jvm() {
        return this.jvm;
    }

    public NodesStatsRequest jvm(boolean jvm) {
        this.jvm = jvm;
        return this;
    }

    public boolean threadPool() {
        return this.threadPool;
    }

    public NodesStatsRequest threadPool(boolean threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public boolean network() {
        return this.network;
    }

    public NodesStatsRequest network(boolean network) {
        this.network = network;
        return this;
    }

    public boolean fs() {
        return this.fs;
    }

    public NodesStatsRequest fs(boolean fs) {
        this.fs = fs;
        return this;
    }

    public boolean transport() {
        return this.transport;
    }

    public NodesStatsRequest transport(boolean transport) {
        this.transport = transport;
        return this;
    }

    public boolean http() {
        return this.http;
    }

    public NodesStatsRequest http(boolean http) {
        this.http = http;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readBoolean();
        this.os = in.readBoolean();
        this.process = in.readBoolean();
        this.jvm = in.readBoolean();
        this.threadPool = in.readBoolean();
        this.network = in.readBoolean();
        this.fs = in.readBoolean();
        this.transport = in.readBoolean();
        this.http = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.indices);
        out.writeBoolean(this.os);
        out.writeBoolean(this.process);
        out.writeBoolean(this.jvm);
        out.writeBoolean(this.threadPool);
        out.writeBoolean(this.network);
        out.writeBoolean(this.fs);
        out.writeBoolean(this.transport);
        out.writeBoolean(this.http);
    }
}

