/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;

public class ValidateQueryRequest
extends BroadcastOperationRequest<ValidateQueryRequest> {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    private BytesReference querySource;
    private boolean querySourceUnsafe;
    private boolean explain;
    private String[] types = Strings.EMPTY_ARRAY;

    ValidateQueryRequest() {
    }

    public ValidateQueryRequest(String ... indices) {
        super(indices);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        return validationException;
    }

    @Override
    protected void beforeStart() {
        if (this.querySourceUnsafe) {
            this.querySource = this.querySource.copyBytesArray();
            this.querySourceUnsafe = false;
        }
    }

    BytesReference querySource() {
        return this.querySource;
    }

    @Required
    public ValidateQueryRequest query(QueryBuilder queryBuilder) {
        this.querySource = queryBuilder.buildAsBytes();
        this.querySourceUnsafe = false;
        return this;
    }

    @Required
    public ValidateQueryRequest query(Map querySource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(querySource);
            return this.query(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + querySource + "]", e);
        }
    }

    @Required
    public ValidateQueryRequest query(XContentBuilder builder) {
        this.querySource = builder.bytes();
        this.querySourceUnsafe = false;
        return this;
    }

    @Required
    public ValidateQueryRequest query(String querySource) {
        this.querySource = new BytesArray(querySource);
        this.querySourceUnsafe = false;
        return this;
    }

    @Required
    public ValidateQueryRequest query(byte[] querySource) {
        return this.query(querySource, 0, querySource.length, false);
    }

    @Required
    public ValidateQueryRequest query(byte[] querySource, int offset, int length, boolean unsafe) {
        return this.query(new BytesArray(querySource, offset, length), unsafe);
    }

    @Required
    public ValidateQueryRequest query(BytesReference querySource, boolean unsafe) {
        this.querySource = querySource;
        this.querySourceUnsafe = unsafe;
        return this;
    }

    String[] types() {
        return this.types;
    }

    public ValidateQueryRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public void explain(boolean explain) {
        this.explain = explain;
    }

    public boolean explain() {
        return this.explain;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.querySourceUnsafe = false;
        this.querySource = in.readBytesReference();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readUTF();
            }
        }
        this.explain = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.querySource);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
        out.writeBoolean(this.explain);
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.querySource, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "[" + Arrays.toString(this.indices) + "]" + Arrays.toString(this.types) + ", querySource[" + sSource + "], explain:" + this.explain;
    }
}

