/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import java.io.IOException;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class ShardCountRequest
extends BroadcastShardOperationRequest {
    private float minScore;
    private BytesReference querySource;
    private String[] types = Strings.EMPTY_ARRAY;
    @Nullable
    private String[] filteringAliases;

    ShardCountRequest() {
    }

    public ShardCountRequest(String index, int shardId, @Nullable String[] filteringAliases, CountRequest request) {
        super(index, shardId, request);
        this.minScore = request.minScore();
        this.querySource = request.querySource();
        this.types = request.types();
        this.filteringAliases = filteringAliases;
    }

    public float minScore() {
        return this.minScore;
    }

    public BytesReference querySource() {
        return this.querySource;
    }

    public String[] types() {
        return this.types;
    }

    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int aliasesSize;
        super.readFrom(in);
        this.minScore = in.readFloat();
        this.querySource = in.readBytesReference();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readUTF();
            }
        }
        if ((aliasesSize = in.readVInt()) > 0) {
            this.filteringAliases = new String[aliasesSize];
            for (int i = 0; i < aliasesSize; ++i) {
                this.filteringAliases[i] = in.readUTF();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeFloat(this.minScore);
        out.writeBytesReference(this.querySource);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
        if (this.filteringAliases != null) {
            out.writeVInt(this.filteringAliases.length);
            for (String alias : this.filteringAliases) {
                out.writeUTF(alias);
            }
        } else {
            out.writeVInt(0);
        }
    }
}

