/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchRequest;

public abstract class TransportSearchHelper {
    public static ShardSearchRequest internalSearchRequest(ShardRouting shardRouting, int numberOfShards, SearchRequest request, String[] filteringAliases, long nowInMillis) {
        ShardSearchRequest shardRequest = new ShardSearchRequest(request, shardRouting, numberOfShards);
        shardRequest.filteringAliases(filteringAliases);
        shardRequest.nowInMillis(nowInMillis);
        return shardRequest;
    }

    public static InternalScrollSearchRequest internalScrollSearchRequest(long id, SearchScrollRequest request) {
        return new InternalScrollSearchRequest(request, id);
    }

    public static String buildScrollId(SearchType searchType, Collection<? extends SearchPhaseResult> searchPhaseResults, @Nullable Map<String, String> attributes) throws IOException {
        if (searchType == SearchType.DFS_QUERY_THEN_FETCH || searchType == SearchType.QUERY_THEN_FETCH) {
            return TransportSearchHelper.buildScrollId("queryThenFetch", searchPhaseResults, attributes);
        }
        if (searchType == SearchType.QUERY_AND_FETCH || searchType == SearchType.DFS_QUERY_AND_FETCH) {
            return TransportSearchHelper.buildScrollId("queryAndFetch", searchPhaseResults, attributes);
        }
        if (searchType == SearchType.SCAN) {
            return TransportSearchHelper.buildScrollId("scan", searchPhaseResults, attributes);
        }
        throw new ElasticSearchIllegalStateException();
    }

    public static String buildScrollId(String type, Collection<? extends SearchPhaseResult> searchPhaseResults, @Nullable Map<String, String> attributes) throws IOException {
        StringBuilder sb = new StringBuilder().append(type).append(';');
        sb.append(searchPhaseResults.size()).append(';');
        for (SearchPhaseResult searchPhaseResult : searchPhaseResults) {
            sb.append(searchPhaseResult.id()).append(':').append(searchPhaseResult.shardTarget().nodeId()).append(';');
        }
        if (attributes == null) {
            sb.append("0;");
        } else {
            sb.append(attributes.size()).append(";");
            for (Map.Entry entry : attributes.entrySet()) {
                sb.append((String)entry.getKey()).append(':').append((String)entry.getValue()).append(';');
            }
        }
        return Base64.encodeBytes(Unicode.fromStringAsBytes(sb.toString()), 16);
    }

    public static ParsedScrollId parseScrollId(String scrollId) {
        ImmutableMap<String, String> attributes;
        int attributesSize;
        try {
            scrollId = Unicode.fromBytes(Base64.decode(scrollId, 16));
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to decode scrollId", e);
        }
        String[] elements = Strings.splitStringToArray(scrollId, ';');
        int index = 0;
        String type = elements[index++];
        int contextSize = Integer.parseInt(elements[index++]);
        Tuple[] context = new Tuple[contextSize];
        for (int i = 0; i < contextSize; ++i) {
            String element;
            int sep;
            if ((sep = (element = elements[index++]).indexOf(58)) == -1) {
                throw new ElasticSearchIllegalArgumentException("Malformed scrollId [" + scrollId + "]");
            }
            context[i] = new Tuple<String, Long>(element.substring(sep + 1), Long.parseLong(element.substring(0, sep)));
        }
        if ((attributesSize = Integer.parseInt(elements[index++])) == 0) {
            attributes = ImmutableMap.of();
        } else {
            attributes = Maps.newHashMapWithExpectedSize(attributesSize);
            for (int i = 0; i < attributesSize; ++i) {
                String element = elements[index++];
                int sep = element.indexOf(58);
                attributes.put(element.substring(0, sep), element.substring(sep + 1));
            }
        }
        return new ParsedScrollId(scrollId, type, context, attributes);
    }

    private TransportSearchHelper() {
    }
}

