/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import org.elasticsearch.common.collect.Lists;

public abstract class Decision {
    public static final Decision ALWAYS = new Single(Type.YES);
    public static final Decision YES = new Single(Type.YES);
    public static final Decision NO = new Single(Type.NO);
    public static final Decision THROTTLE = new Single(Type.THROTTLE);

    public static Decision single(Type type, String explanation, Object ... explanationParams) {
        return new Single(type, explanation, explanationParams);
    }

    public abstract Type type();

    public static class Multi
    extends Decision {
        private final List<Decision> decisions = Lists.newArrayList();

        public Multi add(Decision decision) {
            this.decisions.add(decision);
            return this;
        }

        @Override
        public Type type() {
            Type ret = Type.YES;
            for (int i = 0; i < this.decisions.size(); ++i) {
                Type type = this.decisions.get(i).type();
                if (type == Type.NO) {
                    return type;
                }
                if (type != Type.THROTTLE) continue;
                ret = type;
            }
            return ret;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Decision decision : this.decisions) {
                sb.append("[").append(decision.toString()).append("]");
            }
            return sb.toString();
        }
    }

    public static class Single
    extends Decision {
        private final Type type;
        private final String explanation;
        private final Object[] explanationParams;

        public Single(Type type) {
            this(type, null, null);
        }

        public Single(Type type, String explanation, Object ... explanationParams) {
            this.type = type;
            this.explanation = explanation;
            this.explanationParams = explanationParams;
        }

        @Override
        public Type type() {
            return this.type;
        }

        public String toString() {
            if (this.explanation == null) {
                return (Object)((Object)this.type) + "()";
            }
            return (Object)((Object)this.type) + "(" + String.format(this.explanation, this.explanationParams) + ")";
        }
    }

    public static enum Type {
        YES,
        NO,
        THROTTLE;

    }
}

