/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.component;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;

public abstract class AbstractLifecycleComponent<T>
extends AbstractComponent
implements LifecycleComponent<T> {
    protected final Lifecycle lifecycle = new Lifecycle();
    private final List<LifecycleListener> listeners = new CopyOnWriteArrayList<LifecycleListener>();

    protected AbstractLifecycleComponent(Settings settings) {
        super(settings);
    }

    protected AbstractLifecycleComponent(Settings settings, Class customClass) {
        super(settings, customClass);
    }

    protected AbstractLifecycleComponent(Settings settings, Class loggerClass, Class componentClass) {
        super(settings, loggerClass, componentClass);
    }

    protected AbstractLifecycleComponent(Settings settings, String prefixSettings) {
        super(settings, prefixSettings);
    }

    protected AbstractLifecycleComponent(Settings settings, String prefixSettings, Class customClass) {
        super(settings, prefixSettings, customClass);
    }

    protected AbstractLifecycleComponent(Settings settings, String prefixSettings, Class loggerClass, Class componentClass) {
        super(settings, prefixSettings, loggerClass, componentClass);
    }

    @Override
    public Lifecycle.State lifecycleState() {
        return this.lifecycle.state();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public T start() throws ElasticSearchException {
        if (!this.lifecycle.canMoveToStarted()) {
            return (T)this;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeStart();
        }
        this.doStart();
        this.lifecycle.moveToStarted();
        for (LifecycleListener listener : this.listeners) {
            listener.afterStart();
        }
        return (T)this;
    }

    protected abstract void doStart() throws ElasticSearchException;

    @Override
    public T stop() throws ElasticSearchException {
        if (!this.lifecycle.canMoveToStopped()) {
            return (T)this;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeStop();
        }
        this.lifecycle.moveToStopped();
        this.doStop();
        for (LifecycleListener listener : this.listeners) {
            listener.afterStop();
        }
        return (T)this;
    }

    protected abstract void doStop() throws ElasticSearchException;

    @Override
    public void close() throws ElasticSearchException {
        if (this.lifecycle.started()) {
            this.stop();
        }
        if (!this.lifecycle.canMoveToClosed()) {
            return;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeClose();
        }
        this.lifecycle.moveToClosed();
        this.doClose();
        for (LifecycleListener listener : this.listeners) {
            listener.afterClose();
        }
    }

    protected abstract void doClose() throws ElasticSearchException;
}

