/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.compress.CompressedIndexInput;
import org.elasticsearch.common.compress.snappy.SnappyCompressor;
import org.elasticsearch.common.compress.snappy.SnappyCompressorContext;

public abstract class SnappyCompressedIndexInput
extends CompressedIndexInput<SnappyCompressorContext> {
    protected int chunkSize;
    protected int maxCompressedChunkLength;
    protected byte[] inputBuffer;

    public SnappyCompressedIndexInput(IndexInput in, SnappyCompressorContext context) throws IOException {
        super(in, context);
        this.uncompressed = new byte[this.chunkSize];
        this.uncompressedLength = this.chunkSize;
        this.inputBuffer = new byte[Math.max(this.chunkSize, this.maxCompressedChunkLength)];
    }

    @Override
    protected void readHeader(IndexInput in) throws IOException {
        byte[] header = new byte[SnappyCompressor.HEADER.length];
        in.readBytes(header, 0, header.length);
        if (!Arrays.equals(header, SnappyCompressor.HEADER)) {
            throw new IOException("wrong snappy compressed header [" + Arrays.toString(header) + "]");
        }
        this.chunkSize = in.readVInt();
        this.maxCompressedChunkLength = in.readVInt();
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    public Object clone() {
        SnappyCompressedIndexInput cloned = (SnappyCompressedIndexInput)super.clone();
        cloned.inputBuffer = new byte[this.inputBuffer.length];
        return cloned;
    }
}

