/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.smile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.elasticsearch.common.jackson.core.JsonEncoding;
import org.elasticsearch.common.jackson.core.JsonFactory;
import org.elasticsearch.common.jackson.core.JsonGenerationException;
import org.elasticsearch.common.jackson.core.JsonGenerator;
import org.elasticsearch.common.jackson.core.JsonParseException;
import org.elasticsearch.common.jackson.core.JsonParser;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.format.InputAccessor;
import org.elasticsearch.common.jackson.core.format.MatchStrength;
import org.elasticsearch.common.jackson.core.io.IOContext;
import org.elasticsearch.common.jackson.dataformat.smile.ModuleVersion;
import org.elasticsearch.common.jackson.dataformat.smile.SmileGenerator;
import org.elasticsearch.common.jackson.dataformat.smile.SmileParser;
import org.elasticsearch.common.jackson.dataformat.smile.SmileParserBootstrapper;

public class SmileFactory
extends JsonFactory {
    public static final String FORMAT_NAME_SMILE = "Smile";
    static final int DEFAULT_SMILE_PARSER_FEATURE_FLAGS = SmileParser.Feature.collectDefaults();
    static final int DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS = SmileGenerator.Feature.collectDefaults();
    protected boolean _cfgDelegateToTextual;
    protected int _smileParserFeatures = DEFAULT_SMILE_PARSER_FEATURE_FLAGS;
    protected int _smileGeneratorFeatures = DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS;

    public SmileFactory() {
        this(null);
    }

    public SmileFactory(ObjectCodec oc) {
        super(oc);
    }

    public SmileFactory copy() {
        this._checkInvalidCopy(SmileFactory.class);
        return new SmileFactory(null);
    }

    public void delegateToTextual(boolean state) {
        this._cfgDelegateToTextual = state;
    }

    public Version version() {
        return ModuleVersion.instance.version();
    }

    public String getFormatName() {
        return FORMAT_NAME_SMILE;
    }

    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return SmileParserBootstrapper.hasSmileFormat(acc);
    }

    public final SmileFactory configure(SmileParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public SmileFactory enable(SmileParser.Feature f) {
        this._smileParserFeatures |= f.getMask();
        return this;
    }

    public SmileFactory disable(SmileParser.Feature f) {
        this._smileParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(SmileParser.Feature f) {
        return (this._smileParserFeatures & f.getMask()) != 0;
    }

    public final SmileFactory configure(SmileGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public SmileFactory enable(SmileGenerator.Feature f) {
        this._smileGeneratorFeatures |= f.getMask();
        return this;
    }

    public SmileFactory disable(SmileGenerator.Feature f) {
        this._smileGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(SmileGenerator.Feature f) {
        return (this._smileGeneratorFeatures & f.getMask()) != 0;
    }

    public SmileParser createParser(File f) throws IOException, JsonParseException {
        return this._createParser(new FileInputStream(f), this._createContext(f, true));
    }

    public SmileParser createParser(URL url) throws IOException, JsonParseException {
        return this._createParser(this._optimizedStreamFromURL(url), this._createContext(url, true));
    }

    public SmileParser createParser(InputStream in) throws IOException, JsonParseException {
        return this._createParser(in, this._createContext(in, false));
    }

    public SmileParser createParser(byte[] data) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(data, true);
        return this._createParser(data, 0, data.length, ctxt);
    }

    public SmileParser createParser(byte[] data, int offset, int len) throws IOException, JsonParseException {
        return this._createParser(data, offset, len, this._createContext(data, true));
    }

    @Deprecated
    public SmileParser createJsonParser(File f) throws IOException, JsonParseException {
        return this._createParser(new FileInputStream(f), this._createContext(f, true));
    }

    @Deprecated
    public SmileParser createJsonParser(URL url) throws IOException, JsonParseException {
        return this._createParser(this._optimizedStreamFromURL(url), this._createContext(url, true));
    }

    @Deprecated
    public SmileParser createJsonParser(InputStream in) throws IOException, JsonParseException {
        return this._createParser(in, this._createContext(in, false));
    }

    @Deprecated
    public SmileParser createJsonParser(byte[] data) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(data, true);
        return this._createParser(data, 0, data.length, ctxt);
    }

    @Deprecated
    public SmileParser createJsonParser(byte[] data, int offset, int len) throws IOException, JsonParseException {
        return this._createParser(data, offset, len, this._createContext(data, true));
    }

    public SmileGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this._createGenerator(out, this._createContext(out, false));
    }

    public SmileGenerator createGenerator(OutputStream out) throws IOException {
        return this._createGenerator(out, this._createContext(out, false));
    }

    @Deprecated
    public SmileGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this._createGenerator(out, this._createContext(out, false));
    }

    @Deprecated
    public SmileGenerator createJsonGenerator(OutputStream out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return this._createGenerator(out, ctxt);
    }

    @Deprecated
    protected SmileGenerator _createUTF8JsonGenerator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createGenerator(out, ctxt);
    }

    protected SmileParser _createParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        return new SmileParserBootstrapper(ctxt, in).constructParser(this._parserFeatures, this._smileParserFeatures, this.isEnabled(JsonFactory.Feature.INTERN_FIELD_NAMES), this._objectCodec, this._rootByteSymbols);
    }

    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        if (this._cfgDelegateToTextual) {
            return super._createParser(r, ctxt);
        }
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    protected SmileParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        return new SmileParserBootstrapper(ctxt, data, offset, len).constructParser(this._parserFeatures, this._smileParserFeatures, this.isEnabled(JsonFactory.Feature.INTERN_FIELD_NAMES), this._objectCodec, this._rootByteSymbols);
    }

    protected JsonGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createGenerator(out, ctxt);
        }
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    protected JsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createGenerator(out, ctxt);
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createWriter(out, enc, ctxt);
        }
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    protected SmileGenerator _createGenerator(OutputStream out, IOContext ctxt) throws IOException {
        int feats = this._smileGeneratorFeatures;
        SmileGenerator gen = new SmileGenerator(ctxt, this._generatorFeatures, feats, this._objectCodec, out);
        if ((feats & SmileGenerator.Feature.WRITE_HEADER.getMask()) != 0) {
            gen.writeHeader();
        } else {
            if ((feats & SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES.getMask()) != 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but CHECK_SHARED_STRING_VALUES enabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or disable CHECK_SHARED_STRING_VALUES to resolve)");
            }
            if ((feats & SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT.getMask()) == 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but ENCODE_BINARY_AS_7BIT disabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or ENCODE_BINARY_AS_7BIT to resolve)");
            }
        }
        return gen;
    }
}

