/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.spatial;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.GeoShapeConstants;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.lucene.spatial.prefix.NodeTokenStream;
import org.elasticsearch.common.lucene.spatial.prefix.tree.Node;
import org.elasticsearch.common.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.elasticsearch.index.mapper.FieldMapper;

public abstract class SpatialStrategy {
    private final FieldMapper.Names fieldName;
    private final double distanceErrorPct;
    private final SpatialPrefixTree prefixTree;
    private ThreadLocal<NodeTokenStream> nodeTokenStream = new ThreadLocal<NodeTokenStream>(){

        @Override
        protected NodeTokenStream initialValue() {
            return new NodeTokenStream();
        }
    };

    protected SpatialStrategy(FieldMapper.Names fieldName, SpatialPrefixTree prefixTree, double distanceErrorPct) {
        this.fieldName = fieldName;
        this.prefixTree = prefixTree;
        this.distanceErrorPct = distanceErrorPct;
    }

    public Fieldable createField(Shape shape) {
        int detailLevel = this.prefixTree.getLevelForDistance(this.calcDistanceFromErrPct(shape, this.distanceErrorPct, (SpatialContext)GeoShapeConstants.SPATIAL_CONTEXT));
        List<Node> nodes = this.prefixTree.getNodes(shape, detailLevel, true);
        NodeTokenStream tokenStream = this.nodeTokenStream.get();
        tokenStream.setNodes(nodes);
        return new Field(this.fieldName.indexName(), tokenStream);
    }

    public Filter createFilter(Shape shape, ShapeRelation relation) {
        switch (relation) {
            case INTERSECTS: {
                return this.createIntersectsFilter(shape);
            }
            case WITHIN: {
                return this.createWithinFilter(shape);
            }
            case DISJOINT: {
                return this.createDisjointFilter(shape);
            }
        }
        throw new UnsupportedOperationException("Shape Relation [" + relation.getRelationName() + "] not currently supported");
    }

    public Query createQuery(Shape shape, ShapeRelation relation) {
        switch (relation) {
            case INTERSECTS: {
                return this.createIntersectsQuery(shape);
            }
            case WITHIN: {
                return this.createWithinQuery(shape);
            }
            case DISJOINT: {
                return this.createDisjointQuery(shape);
            }
        }
        throw new UnsupportedOperationException("Shape Relation [" + relation.getRelationName() + "] not currently supported");
    }

    public abstract Filter createIntersectsFilter(Shape var1);

    public abstract Query createIntersectsQuery(Shape var1);

    public abstract Filter createDisjointFilter(Shape var1);

    public abstract Query createDisjointQuery(Shape var1);

    public abstract Filter createWithinFilter(Shape var1);

    public abstract Query createWithinQuery(Shape var1);

    public FieldMapper.Names getFieldName() {
        return this.fieldName;
    }

    public double getDistanceErrorPct() {
        return this.distanceErrorPct;
    }

    public SpatialPrefixTree getPrefixTree() {
        return this.prefixTree;
    }

    protected final double calcDistanceFromErrPct(Shape shape, double distErrPct, SpatialContext ctx) {
        if (distErrPct < 0.0 || distErrPct > 0.5) {
            throw new IllegalArgumentException("distErrPct " + distErrPct + " must be between [0 to 0.5]");
        }
        if (distErrPct == 0.0 || shape instanceof Point) {
            return 0.0;
        }
        Rectangle bbox = shape.getBoundingBox();
        double diagonalDist = ctx.getDistCalc().distance(ctx.makePoint(bbox.getMinX(), bbox.getMinY()), bbox.getMaxX(), bbox.getMaxY());
        return diagonalDist * 0.5 * distErrPct;
    }
}

