/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.store;

import java.io.IOException;
import java.util.zip.Checksum;
import org.apache.lucene.store.IndexOutput;

public class ChecksumIndexOutput
extends IndexOutput {
    private final IndexOutput out;
    private final Checksum digest;

    public ChecksumIndexOutput(IndexOutput out, Checksum digest) {
        this.out = out;
        this.digest = digest;
    }

    public Checksum digest() {
        return this.digest;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.out.writeByte(b);
        this.digest.update(b);
    }

    @Override
    public void setLength(long length) throws IOException {
        this.out.setLength(length);
    }

    public String toString() {
        return this.out.toString();
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.out.writeBytes(b, offset, length);
        this.digest.update(b, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public long getFilePointer() {
        return this.out.getFilePointer();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.out.seek(pos);
    }

    @Override
    public long length() throws IOException {
        return this.out.length();
    }
}

