/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public class NetworkService
extends AbstractComponent {
    public static final String LOCAL = "#local#";
    private static final String GLOBAL_NETWORK_HOST_SETTING = "network.host";
    private static final String GLOBAL_NETWORK_BINDHOST_SETTING = "network.bind_host";
    private static final String GLOBAL_NETWORK_PUBLISHHOST_SETTING = "network.publish_host";
    private final List<CustomNameResolver> customNameResolvers = new CopyOnWriteArrayList<CustomNameResolver>();

    @Inject
    public NetworkService(Settings settings) {
        super(settings);
        InetSocketTransportAddress.setResolveAddress(settings.getAsBoolean("network.address.serialization.resolve", false));
    }

    public void addCustomNameResolver(CustomNameResolver customNameResolver) {
        this.customNameResolvers.add(customNameResolver);
    }

    public InetAddress resolveBindHostAddress(String bindHost) throws IOException {
        return this.resolveBindHostAddress(bindHost, null);
    }

    public InetAddress resolveBindHostAddress(String bindHost, String defaultValue2) throws IOException {
        return this.resolveInetAddress(bindHost, this.settings.get(GLOBAL_NETWORK_BINDHOST_SETTING, this.settings.get(GLOBAL_NETWORK_HOST_SETTING)), defaultValue2);
    }

    public InetAddress resolvePublishHostAddress(String publishHost) throws IOException {
        InetAddress address = this.resolvePublishHostAddress(publishHost, null);
        if ((address == null || address.isAnyLocalAddress()) && (address = NetworkUtils.getFirstNonLoopbackAddress(NetworkUtils.StackType.IPv4)) == null && (address = NetworkUtils.getFirstNonLoopbackAddress(NetworkUtils.getIpStackType())) == null && (address = NetworkUtils.getLocalAddress()) == null) {
            return NetworkUtils.getLocalhost(NetworkUtils.StackType.IPv4);
        }
        return address;
    }

    public InetAddress resolvePublishHostAddress(String publishHost, String defaultValue2) throws IOException {
        return this.resolveInetAddress(publishHost, this.settings.get(GLOBAL_NETWORK_PUBLISHHOST_SETTING, this.settings.get(GLOBAL_NETWORK_HOST_SETTING)), defaultValue2);
    }

    public InetAddress resolveInetAddress(String host, String defaultValue1, String defaultValue2) throws UnknownHostException, IOException {
        if (host == null) {
            host = defaultValue1;
        }
        if (host == null) {
            host = defaultValue2;
        }
        if (host == null) {
            for (CustomNameResolver customNameResolver : this.customNameResolvers) {
                InetAddress inetAddress = customNameResolver.resolveDefault();
                if (inetAddress == null) continue;
                return inetAddress;
            }
            return null;
        }
        String origHost = host;
        if (host.startsWith("#") && host.endsWith("#") || host.startsWith("_") && host.endsWith("_")) {
            host = host.substring(1, host.length() - 1);
            for (CustomNameResolver customNameResolver : this.customNameResolvers) {
                InetAddress inetAddress = customNameResolver.resolveIfPossible(host);
                if (inetAddress == null) continue;
                return inetAddress;
            }
            if (host.equals("local")) {
                return NetworkUtils.getLocalAddress();
            }
            if (host.startsWith("non_loopback")) {
                if (host.toLowerCase().endsWith(":ipv4")) {
                    return NetworkUtils.getFirstNonLoopbackAddress(NetworkUtils.StackType.IPv4);
                }
                if (host.toLowerCase().endsWith(":ipv6")) {
                    return NetworkUtils.getFirstNonLoopbackAddress(NetworkUtils.StackType.IPv6);
                }
                return NetworkUtils.getFirstNonLoopbackAddress(NetworkUtils.getIpStackType());
            }
            NetworkUtils.StackType stackType = NetworkUtils.getIpStackType();
            if (host.toLowerCase().endsWith(":ipv4")) {
                stackType = NetworkUtils.StackType.IPv4;
                host = host.substring(0, host.length() - 5);
            } else if (host.toLowerCase().endsWith(":ipv6")) {
                stackType = NetworkUtils.StackType.IPv6;
                host = host.substring(0, host.length() - 5);
            }
            List<NetworkInterface> allInterfs = NetworkUtils.getAllAvailableInterfaces();
            for (NetworkInterface ni : allInterfs) {
                if (!ni.isUp() || ni.isLoopback() || !host.equals(ni.getName()) && !host.equals(ni.getDisplayName())) continue;
                return NetworkUtils.getFirstNonLoopbackAddress(ni, stackType);
            }
            throw new IOException("Failed to find network interface for [" + origHost + "]");
        }
        return InetAddress.getByName(host);
    }

    public static interface CustomNameResolver {
        public InetAddress resolveDefault();

        public InetAddress resolveIfPossible(String var1);
    }

    public static final class TcpSettings {
        public static final String TCP_NO_DELAY = "network.tcp.no_delay";
        public static final String TCP_KEEP_ALIVE = "network.tcp.keep_alive";
        public static final String TCP_REUSE_ADDRESS = "network.tcp.reuse_address";
        public static final String TCP_SEND_BUFFER_SIZE = "network.tcp.send_buffer_size";
        public static final String TCP_RECEIVE_BUFFER_SIZE = "network.tcp.receive_buffer_size";
        public static final String TCP_BLOCKING = "network.tcp.blocking";
        public static final String TCP_BLOCKING_SERVER = "network.tcp.blocking_server";
        public static final String TCP_BLOCKING_CLIENT = "network.tcp.blocking_client";
        public static final String TCP_CONNECT_TIMEOUT = "network.tcp.connect_timeout";
        public static final ByteSizeValue TCP_DEFAULT_SEND_BUFFER_SIZE = null;
        public static final ByteSizeValue TCP_DEFAULT_RECEIVE_BUFFER_SIZE = null;
        public static final TimeValue TCP_DEFAULT_CONNECT_TIMEOUT = new TimeValue(30L, TimeUnit.SECONDS);
    }
}

