/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.common.collect.MapBackedSet;
import org.elasticsearch.common.util.concurrent.ConcurrentHashMapLong;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;

public abstract class ConcurrentCollections {
    private static final boolean useNonBlockingMap = Boolean.parseBoolean(System.getProperty("elasticsearch.useNonBlockingMap", "false"));

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <V> ConcurrentMapLong<V> newConcurrentMapLong() {
        return new ConcurrentHashMapLong();
    }

    public static <V> Set<V> newConcurrentSet() {
        return new MapBackedSet(new ConcurrentHashMap());
    }

    public static <T> Queue<T> newQueue() {
        return new LinkedTransferQueue();
    }

    public static <T> BlockingQueue<T> newBlockingQueue() {
        return new LinkedTransferQueue();
    }

    private ConcurrentCollections() {
    }
}

