/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class WordDelimiterTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final byte[] charTypeTable;
    private final boolean generateWordParts;
    private final boolean generateNumberParts;
    private final boolean catenateWords;
    private final boolean catenateNumbers;
    private final boolean catenateAll;
    private final boolean splitOnCaseChange;
    private final boolean preserveOriginal;
    private final boolean splitOnNumerics;
    private final boolean stemEnglishPossessive;
    private final CharArraySet protoWords;
    private static Pattern typePattern = Pattern.compile("(.*)\\s*=>\\s*(.*)\\s*$");
    char[] out = new char[256];

    @Inject
    public WordDelimiterTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        List<String> charTypeTableValues = Analysis.getWordList(env, settings, "type_table");
        this.charTypeTable = charTypeTableValues == null ? WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE : this.parseTypes(charTypeTableValues);
        this.generateWordParts = settings.getAsBoolean("generate_word_parts", true);
        this.generateNumberParts = settings.getAsBoolean("generate_number_parts", true);
        this.catenateWords = settings.getAsBoolean("catenate_words", false);
        this.catenateNumbers = settings.getAsBoolean("catenate_numbers", false);
        this.catenateAll = settings.getAsBoolean("catenate_all", false);
        this.splitOnCaseChange = settings.getAsBoolean("split_on_case_change", true);
        this.preserveOriginal = settings.getAsBoolean("preserve_original", false);
        this.splitOnNumerics = settings.getAsBoolean("split_on_numerics", true);
        this.stemEnglishPossessive = settings.getAsBoolean("stem_english_possessive", true);
        CharArraySet protectedWords = Analysis.getWordSet(env, settings, "protected_words", this.version);
        this.protoWords = protectedWords == null ? null : CharArraySet.copy(Lucene.VERSION, protectedWords);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new WordDelimiterFilter(tokenStream, this.charTypeTable, this.generateWordParts ? 1 : 0, this.generateNumberParts ? 1 : 0, this.catenateWords ? 1 : 0, this.catenateNumbers ? 1 : 0, this.catenateAll ? 1 : 0, this.splitOnCaseChange ? 1 : 0, this.preserveOriginal ? 1 : 0, this.splitOnNumerics ? 1 : 0, this.stemEnglishPossessive ? 1 : 0, this.protoWords);
    }

    private byte[] parseTypes(Collection<String> rules) {
        TreeMap<Character, Byte> typeMap = new TreeMap<Character, Byte>();
        for (String rule : rules) {
            Matcher m = typePattern.matcher(rule);
            if (!m.find()) {
                throw new RuntimeException("Invalid Mapping Rule : [" + rule + "]");
            }
            String lhs = this.parseString(m.group(1).trim());
            Byte rhs = this.parseType(m.group(2).trim());
            if (lhs.length() != 1) {
                throw new RuntimeException("Invalid Mapping Rule : [" + rule + "]. Only a single character is allowed.");
            }
            if (rhs == null) {
                throw new RuntimeException("Invalid Mapping Rule : [" + rule + "]. Illegal type.");
            }
            typeMap.put(Character.valueOf(lhs.charAt(0)), rhs);
        }
        byte[] types = new byte[Math.max(((Character)typeMap.lastKey()).charValue() + '\u0001', WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE.length)];
        for (int i = 0; i < types.length; ++i) {
            types[i] = WordDelimiterIterator.getType(i);
        }
        for (Map.Entry mapping : typeMap.entrySet()) {
            types[((Character)mapping.getKey()).charValue()] = (Byte)mapping.getValue();
        }
        return types;
    }

    private Byte parseType(String s) {
        if (s.equals("LOWER")) {
            return (byte)1;
        }
        if (s.equals("UPPER")) {
            return (byte)2;
        }
        if (s.equals("ALPHA")) {
            return (byte)3;
        }
        if (s.equals("DIGIT")) {
            return (byte)4;
        }
        if (s.equals("ALPHANUM")) {
            return (byte)7;
        }
        if (s.equals("SUBWORD_DELIM")) {
            return (byte)8;
        }
        return null;
    }

    private String parseString(String s) {
        int readPos = 0;
        int len = s.length();
        int writePos = 0;
        while (readPos < len) {
            int c;
            if ((c = s.charAt(readPos++)) == 92) {
                if (readPos >= len) {
                    throw new RuntimeException("Invalid escaped char in [" + s + "]");
                }
                c = s.charAt(readPos++);
                switch (c) {
                    case 92: {
                        c = 92;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 117: {
                        if (readPos + 3 >= len) {
                            throw new RuntimeException("Invalid escaped char in [" + s + "]");
                        }
                        c = (char)Integer.parseInt(s.substring(readPos, readPos + 4), 16);
                        readPos += 4;
                    }
                }
            }
            this.out[writePos++] = c;
        }
        return new String(this.out, 0, writePos);
    }
}

