/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.field.data.soft;

import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.field.data.support.AbstractConcurrentMapFieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.settings.IndexSettings;

public class SoftFieldDataCache
extends AbstractConcurrentMapFieldDataCache
implements RemovalListener<String, FieldData> {
    private final CounterMetric evictions = new CounterMetric();

    @Inject
    public SoftFieldDataCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    @Override
    protected Cache<String, FieldData> buildFieldDataMap() {
        CacheBuilder<String, FieldData> cacheBuilder = CacheBuilder.newBuilder().softValues().removalListener(this);
        return cacheBuilder.build();
    }

    @Override
    public long evictions() {
        return this.evictions.count();
    }

    @Override
    public String type() {
        return "soft";
    }

    @Override
    public void onRemoval(RemovalNotification<String, FieldData> removalNotification) {
        if (removalNotification.wasEvicted()) {
            this.evictions.inc();
        }
    }
}

