/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.id.simple;

import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.index.cache.id.IdReaderCache;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.index.cache.id.simple.SimpleIdReaderTypeCache;

public class SimpleIdReaderCache
implements IdReaderCache {
    private final Object readerCacheKey;
    private final ImmutableMap<String, SimpleIdReaderTypeCache> types;

    public SimpleIdReaderCache(Object readerCacheKey, ImmutableMap<String, SimpleIdReaderTypeCache> types) {
        this.readerCacheKey = readerCacheKey;
        this.types = types;
    }

    @Override
    public Object readerCacheKey() {
        return this.readerCacheKey;
    }

    @Override
    public IdReaderTypeCache type(String type) {
        return this.types.get(type);
    }

    @Override
    public HashedBytesArray parentIdByDoc(String type, int docId) {
        SimpleIdReaderTypeCache typeCache = this.types.get(type);
        if (typeCache != null) {
            return typeCache.parentIdByDoc(docId);
        }
        return null;
    }

    @Override
    public int docById(String type, HashedBytesArray id) {
        SimpleIdReaderTypeCache typeCache = this.types.get(type);
        if (typeCache != null) {
            return typeCache.docById(id);
        }
        return -1;
    }

    @Override
    public long sizeInBytes() {
        long sizeInBytes = 0L;
        for (SimpleIdReaderTypeCache readerTypeCache : this.types.values()) {
            sizeInBytes += readerTypeCache.sizeInBytes();
        }
        return sizeInBytes;
    }

    public HashedBytesArray canReuse(HashedBytesArray id) {
        for (SimpleIdReaderTypeCache typeCache : this.types.values()) {
            HashedBytesArray wrap = typeCache.canReuse(id);
            if (wrap == null) continue;
            return wrap;
        }
        return null;
    }
}

