/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.ints;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;
import org.elasticsearch.index.field.data.ints.IntFieldData;

public class SingleValueIntFieldData
extends IntFieldData {
    private ThreadLocal<ThreadLocals.CleanableValue<double[]>> doublesValuesCache = new ThreadLocal<ThreadLocals.CleanableValue<double[]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[]> initialValue() {
            return new ThreadLocals.CleanableValue<double[]>(new double[1]);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<int[]>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<int[]>>(){

        @Override
        protected ThreadLocals.CleanableValue<int[]> initialValue() {
            return new ThreadLocals.CleanableValue<int[]>(new int[1]);
        }
    };
    private final int[] ordinals;

    public SingleValueIntFieldData(String fieldName, int[] ordinals, int[] values) {
        super(fieldName, values);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        return super.computeSizeInBytes() + (long)(4 * this.ordinals.length) + (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    @Override
    public boolean multiValued() {
        return false;
    }

    @Override
    public boolean hasValue(int docId) {
        return this.ordinals[docId] != 0;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc.onMissing(docId);
            return;
        }
        proc.onValue(docId, Integer.toString(this.values[loc]));
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.DoubleValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return;
        }
        proc.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.LongValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return;
        }
        proc.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingDoubleValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc.onMissing(docId);
            return;
        }
        proc.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingLongValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc.onMissing(docId);
            return;
        }
        proc.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachValueInDoc(int docId, IntFieldData.ValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc.onMissing(docId);
            return;
        }
        proc.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc) {
        proc.onOrdinal(docId, this.ordinals[docId]);
    }

    @Override
    public double[] doubleValues(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] ret = this.doublesValuesCache.get().get();
        ret[0] = this.values[loc];
        return ret;
    }

    @Override
    public int value(int docId) {
        return this.values[this.ordinals[docId]];
    }

    @Override
    public int[] values(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] ret = this.valuesCache.get().get();
        ret[0] = this.values[loc];
        return ret;
    }
}

