/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.longs;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;
import org.elasticsearch.index.field.data.longs.LongFieldData;

public class MultiValueLongFieldData
extends LongFieldData {
    private static final int VALUE_CACHE_SIZE = 10;
    private ThreadLocal<ThreadLocals.CleanableValue<double[][]>> doublesValuesCache = new ThreadLocal<ThreadLocals.CleanableValue<double[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[][]> initialValue() {
            double[][] value = new double[10][];
            for (int i = 0; i < value.length; ++i) {
                value[i] = new double[i];
            }
            return new ThreadLocals.CleanableValue<double[][]>(value);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<MutableDateTime[][]>> dateTimesCache = new ThreadLocal<ThreadLocals.CleanableValue<MutableDateTime[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<MutableDateTime[][]> initialValue() {
            MutableDateTime[][] value = new MutableDateTime[10][];
            for (int i = 0; i < value.length; ++i) {
                value[i] = new MutableDateTime[i];
                for (int j = 0; j < i; ++j) {
                    value[i][j] = new MutableDateTime(DateTimeZone.UTC);
                }
            }
            return new ThreadLocals.CleanableValue<MutableDateTime[][]>(value);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<long[][]>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<long[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<long[][]> initialValue() {
            long[][] value = new long[10][];
            for (int i = 0; i < value.length; ++i) {
                value[i] = new long[i];
            }
            return new ThreadLocals.CleanableValue<long[][]>(value);
        }
    };
    private final int[][] ordinals;

    public MultiValueLongFieldData(String fieldName, int[][] ordinals, long[] values) {
        super(fieldName, values);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        long size = super.computeSizeInBytes();
        size += (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (int[] ordinal : this.ordinals) {
            size += (long)(4 * ordinal.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
        }
        return size;
    }

    @Override
    public boolean multiValued() {
        return true;
    }

    @Override
    public boolean hasValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc) {
        for (int i = 0; i < this.ordinals.length; ++i) {
            int loc = this.ordinals[i][docId];
            if (loc == 0) {
                if (i != 0) break;
                proc.onMissing(docId);
                break;
            }
            proc.onValue(docId, Long.toString(this.values[loc]));
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.DoubleValueInDocProc proc) {
        int[] ordinal;
        int loc;
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            proc.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.LongValueInDocProc proc) {
        int[] ordinal;
        int loc;
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            proc.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingDoubleValueInDocProc proc) {
        for (int i = 0; i < this.ordinals.length; ++i) {
            int loc = this.ordinals[i][docId];
            if (loc == 0) {
                if (i != 0) break;
                proc.onMissing(docId);
                break;
            }
            proc.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingLongValueInDocProc proc) {
        for (int i = 0; i < this.ordinals.length; ++i) {
            int loc = this.ordinals[i][docId];
            if (loc == 0) {
                if (i != 0) break;
                proc.onMissing(docId);
                break;
            }
            proc.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc) {
        for (int i = 0; i < this.ordinals.length; ++i) {
            int loc = this.ordinals[i][docId];
            if (loc == 0) {
                if (i != 0) break;
                proc.onOrdinal(docId, 0);
                break;
            }
            proc.onOrdinal(docId, loc);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, LongFieldData.ValueInDocProc proc) {
        for (int i = 0; i < this.ordinals.length; ++i) {
            int loc = this.ordinals[i][docId];
            if (loc == 0) {
                if (i != 0) break;
                proc.onMissing(docId);
                break;
            }
            proc.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, LongFieldData.DateValueInDocProc proc) {
        int[] ordinal;
        int loc;
        MutableDateTime dateTime = (MutableDateTime)((ThreadLocals.CleanableValue)this.dateTimeCache.get()).get();
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            dateTime.setMillis(this.values[loc]);
            proc.onValue(docId, dateTime);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, MutableDateTime dateTime, LongFieldData.DateValueInDocProc proc) {
        int[] ordinal;
        int loc;
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            dateTime.setMillis(this.values[loc]);
            proc.onValue(docId, dateTime);
        }
    }

    @Override
    public MutableDateTime[] dates(int docId) {
        int i;
        MutableDateTime[] dates;
        int length = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            ++length;
        }
        if (length == 0) {
            return EMPTY_DATETIME_ARRAY;
        }
        if (length < 10) {
            dates = this.dateTimesCache.get().get()[length];
        } else {
            dates = new MutableDateTime[length];
            for (i = 0; i < dates.length; ++i) {
                dates[i] = new MutableDateTime();
            }
        }
        i = 0;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            dates[i++].setMillis(this.values[loc]);
        }
        return dates;
    }

    @Override
    public double[] doubleValues(int docId) {
        int length = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) break;
            ++length;
        }
        if (length == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = length < 10 ? this.doublesValuesCache.get().get()[length] : new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this.values[this.ordinals[i][docId]];
        }
        return doubles;
    }

    @Override
    public long value(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.values[loc];
        }
        return 0L;
    }

    @Override
    public long[] values(int docId) {
        int length = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) break;
            ++length;
        }
        if (length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] longs = length < 10 ? this.valuesCache.get().get()[length] : new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this.values[this.ordinals[i][docId]];
        }
        return longs;
    }
}

