/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.ObjectMapperListener;

public class MergeContext {
    private final DocumentMapper documentMapper;
    private final DocumentMapper.MergeFlags mergeFlags;
    private final List<String> mergeConflicts = Lists.newArrayList();
    private final FieldMapperListener.Aggregator newFieldMappers = new FieldMapperListener.Aggregator();
    private final ObjectMapperListener.Aggregator newObjectMappers = new ObjectMapperListener.Aggregator();

    public MergeContext(DocumentMapper documentMapper, DocumentMapper.MergeFlags mergeFlags) {
        this.documentMapper = documentMapper;
        this.mergeFlags = mergeFlags;
    }

    public DocumentMapper docMapper() {
        return this.documentMapper;
    }

    public DocumentMapper.MergeFlags mergeFlags() {
        return this.mergeFlags;
    }

    public FieldMapperListener.Aggregator newFieldMappers() {
        return this.newFieldMappers;
    }

    public ObjectMapperListener.Aggregator newObjectMappers() {
        return this.newObjectMappers;
    }

    public void addConflict(String mergeFailure) {
        this.mergeConflicts.add(mergeFailure);
    }

    public boolean hasConflicts() {
        return !this.mergeConflicts.isEmpty();
    }

    public String[] buildConflicts() {
        return this.mergeConflicts.toArray(new String[this.mergeConflicts.size()]);
    }
}

