/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.UidFilter;

public class IdsFilterParser
implements FilterParser {
    public static final String NAME = "ids";

    @Inject
    public IdsFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        ArrayList<String> ids = new ArrayList<String>();
        Collection<String> types = null;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                String value;
                if ("values".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        value = parser.textOrNull();
                        if (value == null) {
                            throw new QueryParsingException(parseContext.index(), "No value specified for term filter");
                        }
                        ids.add(value);
                    }
                    continue;
                }
                if ("types".equals(currentFieldName) || "type".equals(currentFieldName)) {
                    types = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        value = parser.textOrNull();
                        if (value == null) {
                            throw new QueryParsingException(parseContext.index(), "No type specified for term filter");
                        }
                        types.add(value);
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[ids] filter does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("type".equals(currentFieldName) || "_type".equals(currentFieldName)) {
                types = ImmutableList.of(parser.text());
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[ids] filter does not support [" + currentFieldName + "]");
        }
        if (ids.size() == 0) {
            throw new QueryParsingException(parseContext.index(), "[ids] filter, no ids values provided");
        }
        if (types == null || types.isEmpty()) {
            types = parseContext.queryTypes();
        } else if (types.size() == 1 && ((String)Iterables.getFirst(types, null)).equals("_all")) {
            types = parseContext.mapperService().types();
        }
        UidFilter filter = new UidFilter(types, ids, parseContext.indexCache().bloomCache());
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

