/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class MatchQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<MatchQueryBuilder> {
    private final String name;
    private final Object text;
    private Type type;
    private Operator operator;
    private String analyzer;
    private Float boost;
    private Integer slop;
    private String fuzziness;
    private Integer prefixLength;
    private Integer maxExpansions;
    private String minimumShouldMatch;
    private String rewrite = null;
    private String fuzzyRewrite = null;
    private Boolean lenient;
    private ZeroTermsQuery zeroTermsQuery;

    public MatchQueryBuilder(String name, Object text) {
        this.name = name;
        this.text = text;
    }

    public MatchQueryBuilder type(Type type) {
        this.type = type;
        return this;
    }

    public MatchQueryBuilder operator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public MatchQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public MatchQueryBuilder boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    public MatchQueryBuilder slop(int slop) {
        this.slop = slop;
        return this;
    }

    public MatchQueryBuilder fuzziness(Object fuzziness) {
        this.fuzziness = fuzziness.toString();
        return this;
    }

    public MatchQueryBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public MatchQueryBuilder maxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
        return this;
    }

    public MatchQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public MatchQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public MatchQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    public MatchQueryBuilder setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public MatchQueryBuilder zeroTermsQuery(ZeroTermsQuery zeroTermsQuery) {
        this.zeroTermsQuery = zeroTermsQuery;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("match");
        builder.startObject(this.name);
        builder.field("query", this.text);
        if (this.type != null) {
            builder.field("type", this.type.toString().toLowerCase(Locale.ENGLISH));
        }
        if (this.operator != null) {
            builder.field("operator", this.operator.toString());
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.boost != null) {
            builder.field("boost", this.boost);
        }
        if (this.slop != null) {
            builder.field("slop", this.slop);
        }
        if (this.fuzziness != null) {
            builder.field("fuzziness", this.fuzziness);
        }
        if (this.prefixLength != null) {
            builder.field("prefix_length", this.prefixLength);
        }
        if (this.maxExpansions != null) {
            builder.field("max_expansions", this.maxExpansions);
        }
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        if (this.rewrite != null) {
            builder.field("rewrite", this.rewrite);
        }
        if (this.fuzzyRewrite != null) {
            builder.field("fuzzy_rewrite", this.fuzzyRewrite);
        }
        if (this.lenient != null) {
            builder.field("lenient", (Object)this.lenient);
        }
        if (this.zeroTermsQuery != null) {
            builder.field("zero_terms_query", this.zeroTermsQuery.toString());
        }
        builder.endObject();
        builder.endObject();
    }

    public static enum ZeroTermsQuery {
        NONE,
        ALL;

    }

    public static enum Type {
        BOOLEAN,
        PHRASE,
        PHRASE_PREFIX;

    }

    public static enum Operator {
        OR,
        AND;

    }
}

