/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShardManagement;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.warmer.ShardIndexWarmerService;
import org.elasticsearch.jmx.JmxService;

public class IndexShardModule
extends AbstractModule {
    private final Settings settings;
    private final ShardId shardId;

    public IndexShardModule(Settings settings, ShardId shardId) {
        this.settings = settings;
        this.shardId = shardId;
    }

    @Override
    protected void configure() {
        this.bind(ShardId.class).toInstance(this.shardId);
        this.bind(IndexShard.class).to(InternalIndexShard.class).asEagerSingleton();
        if (JmxService.shouldExport(this.settings)) {
            this.bind(IndexShardManagement.class).asEagerSingleton();
        }
        this.bind(ShardIndexWarmerService.class).asEagerSingleton();
    }
}

