/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.dfs.AggregatedDfs;

public class CachedDfSource
extends Searcher {
    private final AggregatedDfs dfs;
    private final int maxDoc;

    public CachedDfSource(AggregatedDfs dfs, Similarity similarity) throws IOException {
        this.dfs = dfs;
        this.setSimilarity(similarity);
        this.maxDoc = dfs.maxDoc() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)dfs.maxDoc();
    }

    @Override
    public int docFreq(Term term) {
        int df = this.dfs.dfMap().get(term);
        if (df == -1) {
            return 1;
        }
        return df;
    }

    @Override
    public int[] docFreqs(Term[] terms) {
        int[] result = new int[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            result[i] = this.docFreq(terms[i]);
        }
        return result;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public Query rewrite(Query query) {
        return query;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Document doc(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Document doc(int i, FieldSelector fieldSelector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Explanation explain(Weight weight, int doc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void search(Weight weight, Filter filter, Collector results) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TopDocs search(Weight weight, Filter filter, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) {
        throw new UnsupportedOperationException();
    }
}

