/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import java.util.Map;
import org.apache.lucene.index.Term;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.trove.set.hash.THashSet;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.dfs.DfsPhaseExecutionException;
import org.elasticsearch.search.internal.SearchContext;

public class DfsPhase
implements SearchPhase {
    private static ThreadLocal<ThreadLocals.CleanableValue<THashSet<Term>>> cachedTermsSet = new ThreadLocal<ThreadLocals.CleanableValue<THashSet<Term>>>(){

        @Override
        protected ThreadLocals.CleanableValue<THashSet<Term>> initialValue() {
            return new ThreadLocals.CleanableValue<THashSet<Term>>(new THashSet());
        }
    };

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of();
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        try {
            if (!context.queryRewritten()) {
                context.updateRewriteQuery(context.searcher().rewrite(context.query()));
            }
            THashSet<Term> termsSet = cachedTermsSet.get().get();
            termsSet.clear();
            context.query().extractTerms(termsSet);
            Term[] terms = termsSet.toArray(new Term[termsSet.size()]);
            int[] freqs = context.searcher().docFreqs(terms);
            context.dfsResult().termsAndFreqs(terms, freqs);
            context.dfsResult().maxDoc(context.searcher().getIndexReader().maxDoc());
        }
        catch (Exception e) {
            throw new DfsPhaseExecutionException(context, "", (Throwable)e);
        }
    }
}

