/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.AbstractFacetBuilder;

public class StatisticalFacetBuilder
extends AbstractFacetBuilder {
    private String[] fieldsNames;
    private String fieldName;

    public StatisticalFacetBuilder(String name) {
        super(name);
    }

    public StatisticalFacetBuilder field(String field) {
        this.fieldName = field;
        return this;
    }

    public StatisticalFacetBuilder fields(String ... fields) {
        this.fieldsNames = fields;
        return this;
    }

    @Override
    public StatisticalFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public StatisticalFacetBuilder scope(String scope) {
        super.scope(scope);
        return this;
    }

    @Override
    public StatisticalFacetBuilder facetFilter(FilterBuilder filter) {
        this.facetFilter = filter;
        return this;
    }

    @Override
    public StatisticalFacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fieldName == null && this.fieldsNames == null) {
            throw new SearchSourceBuilderException("field must be set on statistical facet for facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.startObject("statistical");
        if (this.fieldsNames != null) {
            if (this.fieldsNames.length == 1) {
                builder.field("field", this.fieldsNames[0]);
            } else {
                builder.field("fields", this.fieldsNames);
            }
        } else {
            builder.field("field", this.fieldName);
        }
        builder.endObject();
        this.addFilterFacetAndGlobal(builder, params);
        builder.endObject();
        return builder;
    }
}

