/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.index;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;

public class IndexNameFacetCollector
extends AbstractFacetCollector {
    private final String indexName;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private int count = 0;

    public IndexNameFacetCollector(String facetName, String indexName, TermsFacet.ComparatorType comparatorType, int size) {
        super(facetName);
        this.indexName = indexName;
        this.comparatorType = comparatorType;
        this.size = size;
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        ++this.count;
    }

    @Override
    public Facet facet() {
        return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, Sets.newHashSet(new InternalStringTermsFacet.StringEntry(this.indexName, this.count)), 0L, this.count);
    }
}

