/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.termsstats.InternalTermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.doubles.TermsStatsDoubleFacetCollector;
import org.elasticsearch.search.facet.termsstats.longs.TermsStatsLongFacetCollector;
import org.elasticsearch.search.facet.termsstats.strings.TermsStatsStringFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStatsFacetProcessor
extends AbstractComponent
implements FacetProcessor {
    @Inject
    public TermsStatsFacetProcessor(Settings settings) {
        super(settings);
        InternalTermsStatsFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"terms_stats", "termsStats"};
    }

    @Override
    public FacetCollector parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String keyField = null;
        String valueField = null;
        int size = 10;
        TermsStatsFacet.ComparatorType comparatorType = TermsStatsFacet.ComparatorType.COUNT;
        String scriptLang = null;
        String script = null;
        Map<String, Object> params = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(currentFieldName)) continue;
                params = parser.map();
                continue;
            }
            if (!token.isValue()) continue;
            if ("key_field".equals(currentFieldName) || "keyField".equals(currentFieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("value_field".equals(currentFieldName) || "valueField".equals(currentFieldName)) {
                valueField = parser.text();
                continue;
            }
            if ("script_field".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("value_script".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("size".equals(currentFieldName)) {
                size = parser.intValue();
                continue;
            }
            if ("all_terms".equals(currentFieldName) || "allTerms".equals(currentFieldName)) {
                if (!parser.booleanValue()) continue;
                size = 0;
                continue;
            }
            if ("order".equals(currentFieldName) || "comparator".equals(currentFieldName)) {
                comparatorType = TermsStatsFacet.ComparatorType.fromString(parser.text());
                continue;
            }
            if ("value_script".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if (!"lang".equals(currentFieldName)) continue;
            scriptLang = parser.text();
        }
        if (keyField == null) {
            throw new FacetPhaseExecutionException(facetName, "[key_field] is required to be set for terms stats facet");
        }
        if (valueField == null && script == null) {
            throw new FacetPhaseExecutionException(facetName, "either [value_field] or [script] are required to be set for terms stats facet");
        }
        FieldMapper keyFieldMapper = context.smartNameFieldMapper(keyField);
        if (keyFieldMapper != null) {
            if (keyFieldMapper.fieldDataType() == FieldDataType.DefaultTypes.LONG) {
                return new TermsStatsLongFacetCollector(facetName, keyField, valueField, size, comparatorType, context, scriptLang, script, params);
            }
            if (keyFieldMapper.fieldDataType() == FieldDataType.DefaultTypes.INT) {
                return new TermsStatsLongFacetCollector(facetName, keyField, valueField, size, comparatorType, context, scriptLang, script, params);
            }
            if (keyFieldMapper.fieldDataType() == FieldDataType.DefaultTypes.SHORT) {
                return new TermsStatsLongFacetCollector(facetName, keyField, valueField, size, comparatorType, context, scriptLang, script, params);
            }
            if (keyFieldMapper.fieldDataType() == FieldDataType.DefaultTypes.BYTE) {
                return new TermsStatsLongFacetCollector(facetName, keyField, valueField, size, comparatorType, context, scriptLang, script, params);
            }
            if (keyFieldMapper.fieldDataType() == FieldDataType.DefaultTypes.DOUBLE) {
                return new TermsStatsDoubleFacetCollector(facetName, keyField, valueField, size, comparatorType, context, scriptLang, script, params);
            }
            if (keyFieldMapper.fieldDataType() == FieldDataType.DefaultTypes.FLOAT) {
                return new TermsStatsDoubleFacetCollector(facetName, keyField, valueField, size, comparatorType, context, scriptLang, script, params);
            }
        }
        return new TermsStatsStringFacetCollector(facetName, keyField, valueField, size, comparatorType, context, scriptLang, script, params);
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        InternalTermsStatsFacet first = (InternalTermsStatsFacet)facets.get(0);
        return first.reduce(name, facets);
    }
}

