/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.ServletMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class ServletWebElement
implements WebElement {
    private ServletMapping servletMapping;

    public ServletWebElement(ServletMapping servletMapping) {
        NullArgumentException.validateNotNull(servletMapping, "Servlet mapping");
        this.servletMapping = servletMapping;
    }

    @Override
    public void register(HttpService httpService, HttpContext httpContext) throws Exception {
        if (this.servletMapping.getAlias() != null) {
            httpService.registerServlet(this.servletMapping.getAlias(), this.servletMapping.getServlet(), DictionaryUtils.adapt(this.servletMapping.getInitParams()), httpContext);
        } else if (WebContainerUtils.isWebContainer(httpService)) {
            ((WebContainer)httpService).registerServlet(this.servletMapping.getServlet(), this.servletMapping.getServletName(), this.servletMapping.getUrlPatterns(), DictionaryUtils.adapt(this.servletMapping.getInitParams()), this.servletMapping.getLoadOnStartup(), this.servletMapping.getAsyncSupported(), httpContext);
        }
    }

    @Override
    public void unregister(HttpService httpService, HttpContext httpContext) {
        if (this.servletMapping.getAlias() != null) {
            httpService.unregister(this.servletMapping.getAlias());
        } else if (WebContainerUtils.isWebContainer(httpService)) {
            ((WebContainer)httpService).unregisterServlet(this.servletMapping.getServlet());
        }
    }

    @Override
    public String getHttpContextId() {
        return this.servletMapping.getHttpContextId();
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("mapping=").append(this.servletMapping).append("}").toString();
    }
}

