/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import io.fabric8.api.Container;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.FabricCommand;
import java.util.ArrayList;

public abstract class ContainerUpgradeSupport
extends FabricCommand {
    protected Profile[] getProfilesForUpgradeOrRollback(Profile[] existingProfiles, Version targetVersion) {
        ArrayList<Profile> list = new ArrayList<Profile>(existingProfiles.length);
        for (Profile old : existingProfiles) {
            Profile newProfile = targetVersion.getProfile(old.getId());
            if (newProfile == null) {
                throw new IllegalArgumentException("Profile " + old.getId() + " with version " + targetVersion + " does not exists");
            }
            list.add(newProfile);
        }
        return list.toArray(new Profile[0]);
    }

    protected int canUpgrade(Version version, Container container) {
        Version current = container.getVersion();
        return version.compareTo((Object)current);
    }

    protected int canRollback(Version version, Container container) {
        return this.canUpgrade(version, container) * -1;
    }
}

