/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.object;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.util.ClassUtil;
import org.jolokia.util.DateUtil;
import org.jolokia.util.EscapeUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class StringToObjectConverter {
    private static final Map<String, Parser> PARSER_MAP = new HashMap<String, Parser>();
    private static final Map<String, Class> TYPE_SIGNATURE_MAP = new HashMap<String, Class>();

    public Object prepareValue(String pExpectedClassName, Object pValue) {
        if (pValue == null) {
            return null;
        }
        Class expectedClass = ClassUtil.classForName(pExpectedClassName);
        Object param = null;
        if (expectedClass != null) {
            param = this.prepareValue(expectedClass, pValue);
        }
        if (param == null) {
            return this.convertFromString(pExpectedClassName, pValue.toString());
        }
        return param;
    }

    private Object prepareValue(Class expectedClass, Object pValue) {
        if (pValue == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(expectedClass)) {
            return Enum.valueOf(expectedClass, pValue.toString());
        }
        return this.prepareForDirectUsage(expectedClass, pValue);
    }

    public static String convertSpecialStringTags(String pValue) {
        if ("[null]".equals(pValue)) {
            return null;
        }
        if ("\"\"".equals(pValue)) {
            return "";
        }
        return pValue;
    }

    private Object prepareForDirectUsage(Class expectedClass, Object pArgument) {
        Class<?> givenClass = pArgument.getClass();
        if (expectedClass.isArray() && List.class.isAssignableFrom(givenClass)) {
            return this.convertListToArray(expectedClass, (List)pArgument);
        }
        return expectedClass.isAssignableFrom(givenClass) ? pArgument : null;
    }

    public Object convertFromString(String pType, String pValue) {
        String value = StringToObjectConverter.convertSpecialStringTags(pValue);
        if (value == null) {
            return null;
        }
        if (pType.startsWith("[") && pType.length() >= 2) {
            return this.convertToArray(pType, value);
        }
        Parser parser = PARSER_MAP.get(pType);
        if (parser == null) {
            throw new IllegalArgumentException("Cannot convert string " + value + " to type " + pType + " because no converter could be found");
        }
        return parser.extract(value);
    }

    private Object convertToArray(String pType, String pValue) {
        Class valueType;
        String t = pType.substring(1, 2);
        if (t.equals("L")) {
            String oType = pType.substring(2, pType.length() - 1).replace('/', '.');
            valueType = ClassUtil.classForName(oType);
            if (valueType == null) {
                throw new IllegalArgumentException("No class of type " + oType + "found");
            }
        } else {
            valueType = TYPE_SIGNATURE_MAP.get(t);
            if (valueType == null) {
                throw new IllegalArgumentException("Cannot convert to unknown array type " + t);
            }
        }
        String[] values = EscapeUtil.splitAsArray(pValue, "!", ",");
        Object ret = Array.newInstance(valueType, values.length);
        int i = 0;
        for (String value : values) {
            Array.set(ret, i++, value.equals("[null]") ? null : this.convertFromString(valueType.getCanonicalName(), value));
        }
        return ret;
    }

    private Object convertListToArray(Class pType, List pList) {
        Class<?> valueType = pType.getComponentType();
        Object ret = Array.newInstance(valueType, pList.size());
        int i = 0;
        for (Object value : pList) {
            if (value == null) {
                if (!valueType.isPrimitive()) {
                    Array.set(ret, i++, null);
                    continue;
                }
                throw new IllegalArgumentException("Cannot use a null value in an array of type " + valueType.getSimpleName());
            }
            if (valueType.isAssignableFrom(value.getClass())) {
                Array.set(ret, i++, value);
                continue;
            }
            Array.set(ret, i++, this.convertFromString(valueType.getCanonicalName(), value.toString()));
        }
        return ret;
    }

    static {
        PARSER_MAP.put(Byte.class.getName(), new ByteParser());
        PARSER_MAP.put("byte", new ByteParser());
        PARSER_MAP.put(Integer.class.getName(), new IntParser());
        PARSER_MAP.put("int", new IntParser());
        PARSER_MAP.put(Long.class.getName(), new LongParser());
        PARSER_MAP.put("long", new LongParser());
        PARSER_MAP.put(Short.class.getName(), new ShortParser());
        PARSER_MAP.put("short", new ShortParser());
        PARSER_MAP.put(Double.class.getName(), new DoubleParser());
        PARSER_MAP.put("double", new DoubleParser());
        PARSER_MAP.put(Float.class.getName(), new FloatParser());
        PARSER_MAP.put("float", new FloatParser());
        PARSER_MAP.put(BigDecimal.class.getName(), new BigDecimalParser());
        PARSER_MAP.put(BigInteger.class.getName(), new BigIntegerParser());
        PARSER_MAP.put(Boolean.class.getName(), new BooleanParser());
        PARSER_MAP.put("boolean", new BooleanParser());
        PARSER_MAP.put("char", new CharParser());
        PARSER_MAP.put(Character.class.getName(), new CharParser());
        PARSER_MAP.put(String.class.getName(), new StringParser());
        PARSER_MAP.put(Date.class.getName(), new DateParser());
        PARSER_MAP.put(ObjectName.class.getName(), new ObjectNameParser());
        PARSER_MAP.put(URL.class.getName(), new URLParser());
        JSONParser jsonExtractor = new JSONParser();
        for (Class type : new Class[]{Map.class, List.class, JSONObject.class, JSONArray.class}) {
            PARSER_MAP.put(type.getName(), jsonExtractor);
        }
        TYPE_SIGNATURE_MAP.put("Z", Boolean.TYPE);
        TYPE_SIGNATURE_MAP.put("B", Byte.TYPE);
        TYPE_SIGNATURE_MAP.put("C", Character.TYPE);
        TYPE_SIGNATURE_MAP.put("S", Short.TYPE);
        TYPE_SIGNATURE_MAP.put("I", Integer.TYPE);
        TYPE_SIGNATURE_MAP.put("J", Long.TYPE);
        TYPE_SIGNATURE_MAP.put("F", Float.TYPE);
        TYPE_SIGNATURE_MAP.put("D", Double.TYPE);
    }

    private static class URLParser
    implements Parser {
        private URLParser() {
        }

        public Object extract(String pValue) {
            try {
                return new URL(pValue);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Cannot parse URL " + pValue + ": " + e, e);
            }
        }
    }

    private static class ObjectNameParser
    implements Parser {
        private ObjectNameParser() {
        }

        public Object extract(String pValue) {
            try {
                return new ObjectName(pValue);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Cannot parse ObjectName " + pValue + ": " + e, e);
            }
        }
    }

    private static class JSONParser
    implements Parser {
        private JSONParser() {
        }

        public Object extract(String pValue) {
            try {
                return new org.json.simple.parser.JSONParser().parse(pValue);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Cannot parse JSON " + pValue + ": " + e, e);
            }
        }
    }

    private static class DateParser
    implements Parser {
        private DateParser() {
        }

        public Object extract(String pValue) {
            try {
                long time = Long.parseLong(pValue);
                return new Date(time);
            }
            catch (NumberFormatException exp) {
                return DateUtil.fromISO8601(pValue);
            }
        }
    }

    private static class BigIntegerParser
    implements Parser {
        private BigIntegerParser() {
        }

        public Object extract(String pValue) {
            return new BigInteger(pValue);
        }
    }

    private static class BigDecimalParser
    implements Parser {
        private BigDecimalParser() {
        }

        public Object extract(String pValue) {
            return new BigDecimal(pValue);
        }
    }

    private static class ShortParser
    implements Parser {
        private ShortParser() {
        }

        public Object extract(String pValue) {
            return Short.parseShort(pValue);
        }
    }

    private static class CharParser
    implements Parser {
        private CharParser() {
        }

        public Object extract(String pValue) {
            return Character.valueOf(pValue.charAt(0));
        }
    }

    private static class ByteParser
    implements Parser {
        private ByteParser() {
        }

        public Object extract(String pValue) {
            return Byte.parseByte(pValue);
        }
    }

    private static class FloatParser
    implements Parser {
        private FloatParser() {
        }

        public Object extract(String pValue) {
            return Float.valueOf(Float.parseFloat(pValue));
        }
    }

    private static class DoubleParser
    implements Parser {
        private DoubleParser() {
        }

        public Object extract(String pValue) {
            return Double.parseDouble(pValue);
        }
    }

    private static class BooleanParser
    implements Parser {
        private BooleanParser() {
        }

        public Object extract(String pValue) {
            return Boolean.parseBoolean(pValue);
        }
    }

    private static class LongParser
    implements Parser {
        private LongParser() {
        }

        public Object extract(String pValue) {
            return Long.parseLong(pValue);
        }
    }

    private static class IntParser
    implements Parser {
        private IntParser() {
        }

        public Object extract(String pValue) {
            return Integer.parseInt(pValue);
        }
    }

    private static class StringParser
    implements Parser {
        private StringParser() {
        }

        public Object extract(String pValue) {
            return pValue;
        }
    }

    private static interface Parser {
        public Object extract(String var1);
    }
}

