/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ComponentRegistryKey;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.config.ScrConfiguration;
import org.apache.felix.scr.impl.helper.Logger;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.XmlHandler;
import org.apache.felix.scr.impl.parser.KXml2SAXParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class BundleComponentActivator
implements Logger {
    private final ComponentRegistry m_componentRegistry;
    private final Bundle m_bundle;
    private final BundleContext m_context;
    private List<ComponentHolder> m_managers = new ArrayList<ComponentHolder>();
    private final ServiceTracker m_logService;
    private final ComponentActorThread m_componentActor;
    private final AtomicBoolean m_active = new AtomicBoolean(true);
    private final CountDownLatch m_closeLatch = new CountDownLatch(1);
    private final ScrConfiguration m_configuration;

    BundleComponentActivator(ComponentRegistry componentRegistry, ComponentActorThread componentActor, BundleContext context, ScrConfiguration configuration) throws ComponentException {
        this.m_componentRegistry = componentRegistry;
        this.m_componentActor = componentActor;
        this.m_context = context;
        this.m_bundle = context.getBundle();
        this.m_logService = new ServiceTracker(context, "org.osgi.service.log.LogService", null);
        this.m_logService.open();
        this.m_configuration = configuration;
        this.log(4, "BundleComponentActivator : Bundle [{0}] active", new Object[]{this.m_bundle.getBundleId()}, null, null, null);
        String descriptorLocations = (String)this.m_bundle.getHeaders().get("Service-Component");
        if (descriptorLocations == null) {
            throw new ComponentException("Service-Component entry not found in the manifest");
        }
        this.initialize(descriptorLocations);
    }

    private void initialize(String descriptorLocations) {
        this.log(4, "BundleComponentActivator : Bundle [{0}] descriptor locations {1}", new Object[]{this.m_bundle.getBundleId(), descriptorLocations}, null, null, null);
        StringTokenizer st = new StringTokenizer(descriptorLocations, ", ");
        while (st.hasMoreTokens()) {
            String descriptorLocation = st.nextToken();
            URL[] descriptorURLs = BundleComponentActivator.findDescriptors(this.m_bundle, descriptorLocation);
            if (descriptorURLs.length == 0) {
                this.log(1, "Component descriptor entry ''{0}'' not found", new Object[]{descriptorLocation}, null, null, null);
                continue;
            }
            for (URL descriptorURL : descriptorURLs) {
                this.loadDescriptor(descriptorURL);
            }
        }
        for (ComponentHolder componentHolder : this.m_managers) {
            this.log(4, "BundleComponentActivator : Bundle [{0}] May enable component holder {1}", new Object[]{this.m_bundle.getBundleId(), componentHolder.getComponentMetadata().getName()}, null, null, null);
            if (componentHolder.getComponentMetadata().isEnabled()) {
                this.log(4, "BundleComponentActivator : Bundle [{0}] Enabling component holder {1}", new Object[]{this.m_bundle.getBundleId(), componentHolder.getComponentMetadata().getName()}, null, null, null);
                componentHolder.enableComponents(false);
                continue;
            }
            this.log(4, "BundleComponentActivator : Bundle [{0}] Will not enable component holder {1}", new Object[]{this.m_bundle.getBundleId(), componentHolder.getComponentMetadata().getName()}, null, null, null);
        }
    }

    static URL[] findDescriptors(Bundle bundle, String descriptorLocation) {
        String filePattern;
        String path;
        if (bundle == null || descriptorLocation == null || descriptorLocation.trim().length() == 0) {
            return new URL[0];
        }
        int lios = descriptorLocation.lastIndexOf("/");
        if (lios > 0) {
            path = descriptorLocation.substring(0, lios);
            filePattern = descriptorLocation.substring(lios + 1);
        } else {
            path = "/";
            filePattern = descriptorLocation;
        }
        Enumeration entries = bundle.findEntries(path, filePattern, false);
        if (entries == null || !entries.hasMoreElements()) {
            return new URL[0];
        }
        ArrayList urls = new ArrayList();
        while (entries.hasMoreElements()) {
            urls.add(entries.nextElement());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDescriptor(URL descriptorURL) {
        String descriptorLocation = descriptorURL.getPath();
        InputStream stream = null;
        try {
            stream = descriptorURL.openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            XmlHandler handler = new XmlHandler(this.m_bundle, this);
            KXml2SAXParser parser = new KXml2SAXParser(in);
            parser.parseXML(handler);
            for (Object o : handler.getComponentMetadataList()) {
                ComponentMetadata metadata = (ComponentMetadata)o;
                ComponentRegistryKey key = null;
                try {
                    if (metadata.getName() != null) {
                        key = this.m_componentRegistry.checkComponentName(this.m_bundle, metadata.getName());
                    }
                    metadata.validate(this);
                    ComponentHolder holder = this.m_componentRegistry.createComponentHolder(this, metadata);
                    this.m_componentRegistry.registerComponentHolder(key, holder);
                    this.m_managers.add(holder);
                    this.log(4, "BundleComponentActivator : Bundle [{0}] ComponentHolder created for {1}", new Object[]{this.m_bundle.getBundleId(), metadata.getName()}, null, null, null);
                }
                catch (Throwable t) {
                    this.log(1, "Cannot register Component", metadata, null, t);
                    if (key == null) continue;
                    this.m_componentRegistry.unregisterComponentHolder(key);
                }
            }
        }
        catch (IOException ex) {
            this.log(1, "Problem reading descriptor entry ''{0}''", new Object[]{descriptorLocation}, null, null, ex);
        }
        catch (Exception ex) {
            this.log(1, "General problem with descriptor entry ''{0}''", new Object[]{descriptorLocation}, null, null, ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose(int reason) {
        if (this.m_active.compareAndSet(true, false)) {
            this.log(4, "BundleComponentActivator : Bundle [{0}] will destroy {1} instances", new Object[]{this.m_context.getBundle().getBundleId(), this.m_managers.size()}, null, null, null);
            while (this.m_managers.size() != 0) {
                ComponentHolder holder = this.m_managers.get(0);
                try {
                    this.m_managers.remove(holder);
                    holder.disposeComponents(reason);
                }
                catch (Exception e) {
                    this.log(1, "BundleComponentActivator : Exception invalidating", holder.getComponentMetadata(), null, e);
                }
                finally {
                    this.m_componentRegistry.unregisterComponentHolder(this.m_context.getBundle(), holder.getComponentMetadata().getName());
                }
            }
            this.log(4, "BundleComponentActivator : Bundle [{0}] STOPPED", new Object[]{this.m_context.getBundle().getBundleId()}, null, null, null);
            this.m_logService.close();
            this.m_closeLatch.countDown();
        } else {
            try {
                this.m_closeLatch.await(this.m_configuration.lockTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isActive() {
        return this.m_active.get();
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public ScrConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public void enableComponent(String name) {
        ComponentHolder[] holder = this.getSelectedComponents(name);
        if (holder == null) {
            return;
        }
        for (ComponentHolder aHolder : holder) {
            try {
                this.log(4, "Enabling Component", aHolder.getComponentMetadata(), null, null);
                aHolder.enableComponents(true);
            }
            catch (Throwable t) {
                this.log(1, "Cannot enable component", aHolder.getComponentMetadata(), null, t);
            }
        }
    }

    public void disableComponent(String name) {
        ComponentHolder[] holder = this.getSelectedComponents(name);
        if (holder == null) {
            return;
        }
        for (ComponentHolder aHolder : holder) {
            try {
                this.log(4, "Disabling Component", aHolder.getComponentMetadata(), null, null);
                aHolder.disableComponents(true);
            }
            catch (Throwable t) {
                this.log(1, "Cannot disable component", aHolder.getComponentMetadata(), null, t);
            }
        }
    }

    private ComponentHolder[] getSelectedComponents(String name) {
        if (name == null) {
            return this.m_managers.toArray(new ComponentHolder[this.m_managers.size()]);
        }
        ComponentHolder componentHolder = this.m_componentRegistry.getComponentHolder(this.m_bundle, name);
        if (componentHolder != null) {
            return new ComponentHolder[]{componentHolder};
        }
        return null;
    }

    public long registerComponentId(AbstractComponentManager componentManager) {
        return this.m_componentRegistry.registerComponentId(componentManager);
    }

    public void unregisterComponentId(AbstractComponentManager componentManager) {
        this.m_componentRegistry.unregisterComponentId(componentManager.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable task) {
        if (this.isActive()) {
            ComponentActorThread cat = this.m_componentActor;
            if (cat != null) {
                cat.schedule(task);
            } else {
                this.log(4, "Component Actor Thread not running, calling synchronously", null, null, null);
                try {
                    BundleComponentActivator bundleComponentActivator = this;
                    synchronized (bundleComponentActivator) {
                        task.run();
                    }
                }
                catch (Throwable t) {
                    this.log(2, "Unexpected problem executing task", null, null, t);
                }
            }
        } else {
            this.log(2, "BundleComponentActivator is not active; not scheduling {0}", new Object[]{task}, null, null, null);
        }
    }

    public boolean isLogEnabled(int level) {
        return this.m_configuration.getLogLevel() >= level;
    }

    public void log(int level, String pattern, Object[] arguments, ComponentMetadata metadata, Long componentId, Throwable ex) {
        if (this.isLogEnabled(level)) {
            String message = MessageFormat.format(pattern, arguments);
            this.log(level, message, metadata, componentId, ex);
        }
    }

    public void log(int level, String message, ComponentMetadata metadata, Long componentId, Throwable ex) {
        if (this.isLogEnabled(level)) {
            ServiceTracker logService;
            if (metadata != null) {
                message = componentId != null ? "[" + metadata.getName() + "(" + componentId + ")] " + message : "[" + metadata.getName() + "] " + message;
            }
            if ((logService = this.m_logService) != null) {
                Object logger = logService.getService();
                if (logger == null) {
                    Activator.log(level, this.m_bundle, message, ex);
                } else {
                    ((LogService)logger).log(level, message, ex);
                }
            } else {
                Activator.log(level, null, message, ex);
            }
        }
    }

    public void missingServicePresent(ServiceReference serviceReference) {
        this.m_componentRegistry.missingServicePresent(serviceReference, this.m_componentActor);
    }

    public void registerMissingDependency(DependencyManager dependencyManager, ServiceReference serviceReference, int trackingCount) {
        this.m_componentRegistry.registerMissingDependency(dependencyManager, serviceReference, trackingCount);
    }
}

