/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.scr.codec;

import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.felix.scr.Reference;
import org.apache.karaf.management.mbeans.scr.ScrServiceMBean;

public class JmxReference {
    public static final CompositeType REFERENCE = JmxReference.createReferenceType();
    public static final TabularType REFERENCE_TABLE = JmxReference.createReferenceTableType();
    private final CompositeData data;

    public JmxReference(Reference reference) {
        try {
            String[] itemNames = ScrServiceMBean.REFERENCE;
            Object[] itemValues = new Object[itemNames.length];
            itemValues[0] = reference.getName();
            itemValues[1] = reference.isSatisfied();
            itemValues[2] = JmxReference.getCardinality(reference);
            itemValues[3] = JmxReference.getAvailability(reference);
            itemValues[4] = JmxReference.getPolicy(reference);
            itemValues[5] = JmxReference.getBoundServices(reference);
            this.data = new CompositeDataSupport(REFERENCE, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form feature open data", e);
        }
    }

    public CompositeData asCompositeData() {
        return this.data;
    }

    public static TabularData tableFrom(Reference ... references) {
        TabularDataSupport table = new TabularDataSupport(REFERENCE_TABLE);
        if (references != null) {
            for (Reference reference : references) {
                table.put(new JmxReference(reference).asCompositeData());
            }
        }
        return table;
    }

    private static CompositeType createReferenceType() {
        try {
            String description = "This type encapsulates Scr references";
            String[] itemNames = ScrServiceMBean.REFERENCE;
            OpenType[] itemTypes = new OpenType[itemNames.length];
            String[] itemDescriptions = new String[itemNames.length];
            itemTypes[0] = SimpleType.STRING;
            itemTypes[1] = SimpleType.BOOLEAN;
            itemTypes[2] = SimpleType.STRING;
            itemTypes[3] = SimpleType.STRING;
            itemTypes[4] = SimpleType.STRING;
            itemTypes[5] = new ArrayType(1, SimpleType.STRING);
            itemDescriptions[0] = "The name of the reference";
            itemDescriptions[1] = "The state of the reference";
            itemDescriptions[2] = "The cardinality of the reference";
            itemDescriptions[3] = "The availability of the reference";
            itemDescriptions[4] = "The policy of the reference";
            itemDescriptions[5] = "The bound services";
            return new CompositeType("Reference", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build reference type", e);
        }
    }

    private static TabularType createReferenceTableType() {
        try {
            return new TabularType("References", "The table of all references", REFERENCE, new String[]{"Name"});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build references table type", e);
        }
    }

    private static String getCardinality(Reference reference) {
        if (reference.isMultiple()) {
            return "Multiple";
        }
        return "Single";
    }

    private static String getAvailability(Reference reference) {
        if (reference.isOptional()) {
            return "Optional";
        }
        return "Mandatory";
    }

    private static String getPolicy(Reference reference) {
        if (reference.isStatic()) {
            return "Static";
        }
        return "Dynamic";
    }

    private static String[] getBoundServices(Reference reference) {
        if (reference.getBoundServiceReferences() == null || reference.getBoundServiceReferences().length == 0) {
            return new String[0];
        }
        String[] ids = new String[reference.getBoundServiceReferences().length];
        for (int i = 0; i < reference.getBoundServiceReferences().length; ++i) {
            ids[i] = String.valueOf(reference.getBoundServiceReferences()[i].getProperty("service.id"));
        }
        return ids;
    }
}

