/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.groups.internal;

import io.fabric8.groups.Group;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ManagedGroupFactory;
import io.fabric8.groups.internal.ZooKeeperGroup;
import io.fabric8.groups.internal.ZooKeeperMultiGroup;
import org.apache.curator.framework.CuratorFramework;

public class StaticManagedGroupFactory
implements ManagedGroupFactory {
    private final CuratorFramework curator;
    private final boolean shouldClose;

    StaticManagedGroupFactory(CuratorFramework curator, boolean shouldClose) {
        this.curator = curator;
        this.shouldClose = shouldClose;
    }

    @Override
    public CuratorFramework getCurator() {
        return this.curator;
    }

    @Override
    public <T extends NodeState> Group<T> createGroup(String path, Class<T> clazz) {
        return new ZooKeeperGroup<T>(this.curator, path, clazz);
    }

    @Override
    public <T extends NodeState> Group<T> createMultiGroup(String path, Class<T> clazz) {
        return new ZooKeeperMultiGroup<T>(this.curator, path, clazz);
    }

    @Override
    public void close() {
        if (this.shouldClose) {
            this.curator.close();
        }
    }
}

