/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.parser;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.apache.xbean.finder.BundleAnnotationFinder;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilterMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebAppJspServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppMimeMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppSecurityConstraint;
import org.ops4j.pax.web.extender.war.internal.model.WebAppSecurityRole;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletContainerInitializer;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletMapping;
import org.ops4j.pax.web.extender.war.internal.parser.WebFilterAnnotationScanner;
import org.ops4j.pax.web.extender.war.internal.parser.WebServletAnnotationScanner;
import org.ops4j.pax.web.extender.war.internal.util.ManifestUtil;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.ops4j.spi.SafeServiceLoader;
import org.ops4j.util.xml.ElementHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class WebAppParser {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppParser.class);
    private ServiceTracker<PackageAdmin, PackageAdmin> packageAdmin;

    public WebAppParser(ServiceTracker<PackageAdmin, PackageAdmin> packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Bundle bundle, WebApp webApp) throws Exception {
        String rootPath = WebAppParser.extractRootPath(bundle);
        if (!rootPath.isEmpty()) {
            rootPath = rootPath + "/";
        }
        Integer majorVersion = 3;
        URL webXmlURL = bundle.getEntry(rootPath + "WEB-INF/web.xml");
        if (webXmlURL != null) {
            InputStream inputStream = webXmlURL.openStream();
            try {
                Element rootElement = ElementHelper.getRootElement(inputStream);
                majorVersion = this.scanMajorVersion(rootElement);
                boolean metaDataComplete = Boolean.parseBoolean(ElementHelper.getAttribute(rootElement, "metadata-complete", "false"));
                webApp.setMetaDataComplete(metaDataComplete);
                LOG.debug("metadata-complete is: {}", (Object)metaDataComplete);
                webApp.setDisplayName(WebAppParser.getTextContent(ElementHelper.getChild(rootElement, "display-name")));
                WebAppParser.parseContextParams(rootElement, webApp);
                WebAppParser.parseSessionConfig(rootElement, webApp);
                WebAppParser.parseServlets(rootElement, webApp);
                WebAppParser.parseFilters(rootElement, webApp);
                WebAppParser.parseListeners(rootElement, webApp);
                WebAppParser.parseErrorPages(rootElement, webApp);
                WebAppParser.parseWelcomeFiles(rootElement, webApp);
                WebAppParser.parseMimeMappings(rootElement, webApp);
                WebAppParser.parseSecurity(rootElement, webApp);
            }
            finally {
                inputStream.close();
            }
        }
        this.servletContainerInitializerScan(bundle, webApp, majorVersion);
        if (!webApp.getMetaDataComplete() && majorVersion != null && majorVersion >= 3 && Boolean.TRUE.equals(WebAppParser.canSeeClass(bundle, WebServlet.class))) {
            this.servletAnnotationScan(bundle, webApp);
        }
        this.tldScan(bundle, webApp);
        URL jettyWebXmlURL = null;
        Enumeration enums = bundle.findEntries(rootPath + "WEB-INF", "*web*.xml", false);
        while (enums != null && enums.hasMoreElements()) {
            URL url = (URL)enums.nextElement();
            if (!WebAppParser.isJettyWebXml(url)) continue;
            if (jettyWebXmlURL == null) {
                jettyWebXmlURL = url;
                continue;
            }
            throw new IllegalArgumentException("Found multiple jetty web xml descriptors. Aborting");
        }
        webApp.setWebXmlURL(webXmlURL);
        webApp.setJettyWebXmlURL(jettyWebXmlURL);
        webApp.setVirtualHostList(WebAppParser.extractVirtualHostList(bundle));
        webApp.setConnectorList(WebAppParser.extractConnectorList(bundle));
        webApp.setRootPath(rootPath);
    }

    private Integer scanMajorVersion(Element rootElement) {
        String version = ElementHelper.getAttribute(rootElement, "version");
        Integer majorVersion = null;
        if (version != null && !version.isEmpty() && version.length() > 2) {
            LOG.debug("version found in web.xml - {}", (Object)version);
            try {
                majorVersion = Integer.parseInt(version.split("\\.")[0]);
            }
            catch (NumberFormatException nfe) {}
        } else if (version != null && !version.isEmpty() && version.length() > 0) {
            try {
                majorVersion = Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return majorVersion;
    }

    private List<URL> findResources(Iterable<Bundle> bundles, String path, String pattern, boolean recurse) {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (Bundle bundle : bundles) {
            Collection names = ((BundleWiring)bundle.adapt(BundleWiring.class)).listResources(path, pattern, 2 | (recurse ? 1 : 0));
            for (String name : names) {
                resources.add(bundle.getResource(name));
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScan(Bundle bundle, WebApp webApp) throws Exception {
        WebAppInitParam param;
        String paramValue;
        StringBuilder builder;
        Set bundlesInClassSpace = ClassPathUtil.getBundlesInClassSpace((Bundle)bundle, new HashSet());
        ArrayList<URL> taglibs = new ArrayList<URL>();
        ArrayList<URL> facesConfigs = new ArrayList<URL>();
        for (URL u : this.findResources(bundlesInClassSpace, "/", "*.tld", true)) {
            InputStream is = u.openStream();
            try {
                Element rootTld = ElementHelper.getRootElement(is);
                if (rootTld == null) continue;
                WebAppParser.parseListeners(rootTld, webApp);
            }
            finally {
                is.close();
            }
        }
        for (URL u : this.findResources(bundlesInClassSpace, "/META-INF", "*.taglib.xml", false)) {
            LOG.info("found taglib {}", (Object)u.toString());
            taglibs.add(u);
        }
        for (URL u : this.findResources(bundlesInClassSpace, "/META-INF", "faces-config.xml", false)) {
            LOG.info("found faces-config.xml {}", (Object)u.toString());
            facesConfigs.add(u);
        }
        if (!taglibs.isEmpty()) {
            builder = new StringBuilder();
            for (URL url : taglibs) {
                builder.append(url);
                builder.append(";");
            }
            paramValue = builder.toString();
            paramValue = paramValue.substring(0, paramValue.length() - 1);
            param = new WebAppInitParam();
            param.setParamName("javax.faces.FACELETS_LIBRARIES");
            param.setParamValue(paramValue);
            webApp.addContextParam(param);
        }
        if (!facesConfigs.isEmpty()) {
            builder = new StringBuilder();
            for (URL url : facesConfigs) {
                builder.append(url);
                builder.append(",");
            }
            paramValue = builder.toString();
            paramValue = paramValue.substring(0, paramValue.length() - 1);
            param = new WebAppInitParam();
            param.setParamName("javax.faces.CONFIG_FILES");
            param.setParamValue(paramValue);
            webApp.addContextParam(param);
        }
    }

    private void servletAnnotationScan(Bundle bundle, WebApp webApp) throws Exception {
        LOG.debug("metadata-complete is either false or not set");
        LOG.debug("scanning for annotated classes");
        BundleAnnotationFinder baf = new BundleAnnotationFinder((PackageAdmin)this.packageAdmin.getService(), bundle);
        LinkedHashSet webServletClasses = new LinkedHashSet(baf.findAnnotatedClasses(WebServlet.class));
        LinkedHashSet webFilterClasses = new LinkedHashSet(baf.findAnnotatedClasses(WebFilter.class));
        LinkedHashSet webListenerClasses = new LinkedHashSet(baf.findAnnotatedClasses(WebListener.class));
        for (Class webServletClass : webServletClasses) {
            LOG.debug("found WebServlet annotation on class: {}", (Object)webServletClass);
            WebServletAnnotationScanner annonScanner = new WebServletAnnotationScanner(bundle, webServletClass.getCanonicalName());
            annonScanner.scan(webApp);
        }
        for (Class webFilterClass : webFilterClasses) {
            LOG.debug("found WebFilter annotation on class: {}", (Object)webFilterClass);
            WebFilterAnnotationScanner filterScanner = new WebFilterAnnotationScanner(bundle, webFilterClass.getCanonicalName());
            filterScanner.scan(webApp);
        }
        for (Class webListenerClass : webListenerClasses) {
            LOG.debug("found WebListener annotation on class: {}", (Object)webListenerClass);
            WebAppParser.addWebListener(webApp, webListenerClass.getCanonicalName());
        }
        LOG.debug("class scanning done");
    }

    private void servletContainerInitializerScan(Bundle bundle, WebApp webApp, Integer majorVersion) throws Exception {
        LOG.debug("scanning for ServletContainerInitializers");
        SafeServiceLoader safeServiceLoader = new SafeServiceLoader(bundle.getClass().getClassLoader());
        List containerInitializers = safeServiceLoader.load("javax.servlet.ServletContainerInitializer");
        for (ServletContainerInitializer servletContainerInitializer : containerInitializers) {
            WebAppServletContainerInitializer webAppServletContainerInitializer = new WebAppServletContainerInitializer();
            webAppServletContainerInitializer.setServletContainerInitializer(servletContainerInitializer);
            if (!webApp.getMetaDataComplete() && majorVersion != null && majorVersion >= 3) {
                Class loadClass = bundle.loadClass("javax.servlet.annotation.HandlesTypes");
                HandlesTypes handlesTypes = (HandlesTypes)loadClass.cast(servletContainerInitializer.getClass().getAnnotation(loadClass));
                LOG.debug("Found HandlesTypes {}", (Object)handlesTypes);
                if (handlesTypes != null) {
                    Class[] classes = handlesTypes.value();
                    webAppServletContainerInitializer.setClasses(classes);
                }
            }
            webApp.addServletContainerInitializer(webAppServletContainerInitializer);
        }
        if (containerInitializers != null) {
            LOG.debug("found container initializers by SafeServiceLoader ... skip the old impl. ");
            return;
        }
    }

    private static void parseSecurity(Element rootElement, WebApp webApp) {
        Element[] loginConfigElements;
        Element[] securityRoleElements;
        String roleName;
        Element[] securityConstraint = ElementHelper.getChildren(rootElement, "security-constraint");
        if (securityConstraint != null && securityConstraint.length > 0) {
            try {
                for (Element scElement : securityConstraint) {
                    Element[] webResourceElements;
                    Element userDataConstraintsElement;
                    WebAppSecurityConstraint webSecurityConstraint = new WebAppSecurityConstraint();
                    Element authConstraintElement = ElementHelper.getChild(scElement, "auth-constraint");
                    if (authConstraintElement != null) {
                        webSecurityConstraint.setAuthenticate(true);
                        Element[] roleElemnts = ElementHelper.getChildren(authConstraintElement, "role-name");
                        if (roleElemnts != null && roleElemnts.length > 0) {
                            for (Element roleElement : roleElemnts) {
                                roleName = WebAppParser.getTextContent(roleElement);
                                webSecurityConstraint.addRole(roleName);
                            }
                        }
                    }
                    if ((userDataConstraintsElement = ElementHelper.getChild(scElement, "user-data-constraint")) != null) {
                        String guarantee = WebAppParser.getTextContent(ElementHelper.getChild(userDataConstraintsElement, "transport-guarantee")).trim().toUpperCase();
                        webSecurityConstraint.setDataConstraint(guarantee);
                    }
                    if ((webResourceElements = ElementHelper.getChildren(scElement, "web-resource-collection")) == null || webResourceElements.length <= 0) continue;
                    for (Element webResourceElement : webResourceElements) {
                        Element[] urlPatternElemnts;
                        WebAppConstraintMapping webConstraintMapping = new WebAppConstraintMapping();
                        WebAppSecurityConstraint sc = (WebAppSecurityConstraint)webSecurityConstraint.clone();
                        String constraintName = WebAppParser.getTextContent(ElementHelper.getChild(webResourceElement, "web-resource-name"));
                        webConstraintMapping.setConstraintName(constraintName);
                        for (Element urlPattern : urlPatternElemnts = ElementHelper.getChildren(webResourceElement, "url-pattern")) {
                            String url = WebAppParser.getTextContent(urlPattern);
                            Element[] httpMethodElements = ElementHelper.getChildren(urlPattern, "http-method");
                            if (httpMethodElements != null && httpMethodElements.length > 0) {
                                for (Element httpMethodElement : httpMethodElements) {
                                    webConstraintMapping.setMapping(WebAppParser.getTextContent(httpMethodElement));
                                    webConstraintMapping.setUrl(url);
                                    webConstraintMapping.setSecurityConstraints(sc);
                                }
                            } else {
                                webConstraintMapping.setUrl(url);
                                webConstraintMapping.setSecurityConstraints(sc);
                            }
                            webApp.addConstraintMapping(webConstraintMapping);
                        }
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                LOG.warn("", (Throwable)e);
            }
        }
        if ((securityRoleElements = ElementHelper.getChildren(rootElement, "security-role")) != null && securityRoleElements.length > 0) {
            for (Element securityRoleElement : securityRoleElements) {
                WebAppSecurityRole webSecurityRole = new WebAppSecurityRole();
                Element[] roleElements = ElementHelper.getChildren(securityRoleElement, "role-name");
                if (roleElements != null && roleElements.length > 0) {
                    for (Element roleElement : roleElements) {
                        roleName = WebAppParser.getTextContent(roleElement);
                        webSecurityRole.addRoleName(roleName);
                    }
                }
                webApp.addSecurityRole(webSecurityRole);
            }
        }
        if ((loginConfigElements = ElementHelper.getChildren(rootElement, "login-config")) != null && loginConfigElements.length > 0) {
            for (Element loginConfigElement : loginConfigElements) {
                WebAppLoginConfig webLoginConfig = new WebAppLoginConfig();
                webLoginConfig.setAuthMethod(WebAppParser.getTextContent(ElementHelper.getChild(loginConfigElement, "auth-method")));
                String realmName = WebAppParser.getTextContent(ElementHelper.getChild(loginConfigElement, "realm-name"));
                webLoginConfig.setRealmName(realmName == null ? "default" : realmName);
                if ("FORM".equalsIgnoreCase(webLoginConfig.getAuthMethod())) {
                    Element formLoginConfigElement = ElementHelper.getChild(loginConfigElement, "form-login-config");
                    webLoginConfig.setFormLoginPage(WebAppParser.getTextContent(ElementHelper.getChild(formLoginConfigElement, "form-login-page")));
                    webLoginConfig.setFormErrorPage(WebAppParser.getTextContent(ElementHelper.getChild(formLoginConfigElement, "form-error-page")));
                }
                webApp.addLoginConfig(webLoginConfig);
            }
        }
    }

    private static void parseContextParams(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "context-param");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppInitParam initParam = new WebAppInitParam();
                initParam.setParamName(WebAppParser.getTextContent(ElementHelper.getChild(element, "param-name")));
                initParam.setParamValue(WebAppParser.getTextContent(ElementHelper.getChild(element, "param-value")));
                webApp.addContextParam(initParam);
            }
        }
    }

    private static void parseSessionConfig(Element rootElement, WebApp webApp) {
        Element stElement;
        Element scElement = ElementHelper.getChild(rootElement, "session-config");
        if (scElement != null && (stElement = ElementHelper.getChild(scElement, "session-timeout")) != null) {
            webApp.setSessionTimeout(WebAppParser.getTextContent(stElement));
        }
    }

    private static void parseServlets(Element rootElement, WebApp webApp) {
        Element[] mappingElements;
        Element[] elements = ElementHelper.getChildren(rootElement, "servlet");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppServlet servlet = new WebAppServlet();
                servlet.setServletName(WebAppParser.getTextContent(ElementHelper.getChild(element, "servlet-name")));
                String servletClass = WebAppParser.getTextContent(ElementHelper.getChild(element, "servlet-class"));
                if (servletClass != null) {
                    servlet.setServletClassName(servletClass);
                    webApp.addServlet(servlet);
                } else {
                    String jspFile = WebAppParser.getTextContent(ElementHelper.getChild(element, "jsp-file"));
                    if (jspFile != null) {
                        WebAppJspServlet jspServlet = new WebAppJspServlet();
                        jspServlet.setServletName(WebAppParser.getTextContent(ElementHelper.getChild(element, "servlet-name")));
                        jspServlet.setJspPath(jspFile);
                        webApp.addServlet(jspServlet);
                    }
                }
                servlet.setLoadOnStartup(WebAppParser.getTextContent(ElementHelper.getChild(element, "load-on-startup")));
                servlet.setAsyncSupported(WebAppParser.getTextContent(ElementHelper.getChild(element, "async-supported")));
                Element[] initParamElements = ElementHelper.getChildren(element, "init-param");
                if (initParamElements == null || initParamElements.length <= 0) continue;
                for (Element initParamElement : initParamElements) {
                    WebAppInitParam initParam = new WebAppInitParam();
                    initParam.setParamName(WebAppParser.getTextContent(ElementHelper.getChild(initParamElement, "param-name")));
                    initParam.setParamValue(WebAppParser.getTextContent(ElementHelper.getChild(initParamElement, "param-value")));
                    servlet.addInitParam(initParam);
                }
            }
        }
        if ((mappingElements = ElementHelper.getChildren(rootElement, "servlet-mapping")) != null && mappingElements.length > 0) {
            for (Element mappingElement : mappingElements) {
                String servletName = WebAppParser.getTextContent(ElementHelper.getChild(mappingElement, "servlet-name"));
                Element[] urlPatternsElements = ElementHelper.getChildren(mappingElement, "url-pattern");
                if (urlPatternsElements == null || urlPatternsElements.length <= 0) continue;
                for (Element urlPatternElement : urlPatternsElements) {
                    WebAppServletMapping servletMapping = new WebAppServletMapping();
                    servletMapping.setServletName(servletName);
                    servletMapping.setUrlPattern(WebAppParser.getTextContent(urlPatternElement));
                    webApp.addServletMapping(servletMapping);
                }
            }
        }
    }

    private static void parseFilters(Element rootElement, WebApp webApp) {
        Element[] mappingElements;
        Element[] elements = ElementHelper.getChildren(rootElement, "filter");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppFilter filter = new WebAppFilter();
                filter.setFilterName(WebAppParser.getTextContent(ElementHelper.getChild(element, "filter-name")));
                filter.setFilterClass(WebAppParser.getTextContent(ElementHelper.getChild(element, "filter-class")));
                webApp.addFilter(filter);
                Element[] initParamElements = ElementHelper.getChildren(element, "init-param");
                if (initParamElements == null || initParamElements.length <= 0) continue;
                for (Element initParamElement : initParamElements) {
                    WebAppInitParam initParam = new WebAppInitParam();
                    initParam.setParamName(WebAppParser.getTextContent(ElementHelper.getChild(initParamElement, "param-name")));
                    initParam.setParamValue(WebAppParser.getTextContent(ElementHelper.getChild(initParamElement, "param-value")));
                    filter.addInitParam(initParam);
                }
            }
        }
        if ((mappingElements = ElementHelper.getChildren(rootElement, "filter-mapping")) != null && mappingElements.length > 0) {
            for (Element mappingElement : mappingElements) {
                Element[] servletNamesElements;
                String filterName = WebAppParser.getTextContent(ElementHelper.getChild(mappingElement, "filter-name"));
                Element[] urlPatternsElements = ElementHelper.getChildren(mappingElement, "url-pattern");
                if (urlPatternsElements != null && urlPatternsElements.length > 0) {
                    for (Element urlPatternElement : urlPatternsElements) {
                        WebAppFilterMapping filterMapping = new WebAppFilterMapping();
                        filterMapping.setFilterName(filterName);
                        filterMapping.setUrlPattern(WebAppParser.getTextContent(urlPatternElement));
                        webApp.addFilterMapping(filterMapping);
                    }
                }
                if ((servletNamesElements = ElementHelper.getChildren(mappingElement, "servlet-name")) == null || servletNamesElements.length <= 0) continue;
                for (Element servletNameElement : servletNamesElements) {
                    WebAppFilterMapping filterMapping = new WebAppFilterMapping();
                    filterMapping.setFilterName(filterName);
                    filterMapping.setServletName(WebAppParser.getTextContent(servletNameElement));
                    webApp.addFilterMapping(filterMapping);
                }
            }
        }
    }

    private static void parseListeners(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "listener");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppParser.addWebListener(webApp, WebAppParser.getTextContent(ElementHelper.getChild(element, "listener-class")));
            }
        }
    }

    private static void parseErrorPages(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "error-page");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppErrorPage errorPage = new WebAppErrorPage();
                errorPage.setErrorCode(WebAppParser.getTextContent(ElementHelper.getChild(element, "error-code")));
                errorPage.setExceptionType(WebAppParser.getTextContent(ElementHelper.getChild(element, "exception-type")));
                errorPage.setLocation(WebAppParser.getTextContent(ElementHelper.getChild(element, "location")));
                webApp.addErrorPage(errorPage);
            }
        }
    }

    private static void parseWelcomeFiles(Element rootElement, WebApp webApp) {
        Element[] elements;
        Element listElement = ElementHelper.getChild(rootElement, "welcome-file-list");
        if (listElement != null && (elements = ElementHelper.getChildren(listElement, "welcome-file")) != null && elements.length > 0) {
            for (Element element : elements) {
                webApp.addWelcomeFile(WebAppParser.getTextContent(element));
            }
        }
    }

    private static void parseMimeMappings(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "mime-mapping");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppMimeMapping mimeMapping = new WebAppMimeMapping();
                mimeMapping.setExtension(WebAppParser.getTextContent(ElementHelper.getChild(element, "extension")));
                mimeMapping.setMimeType(WebAppParser.getTextContent(ElementHelper.getChild(element, "mime-type")));
                webApp.addMimeMapping(mimeMapping);
            }
        }
    }

    private static String getTextContent(Element element) {
        if (element != null) {
            String content = element.getTextContent();
            if (content != null) {
                content = content.trim();
            }
            return content;
        }
        return null;
    }

    private static void addWebListener(WebApp webApp, String clazz) {
        WebAppListener listener = new WebAppListener();
        listener.setListenerClass(clazz);
        webApp.addListener(listener);
    }

    private static String extractRootPath(Bundle bundle) {
        String rootPath = ManifestUtil.getHeader(bundle, "Webapp-Root");
        if (rootPath == null) {
            rootPath = "";
        }
        rootPath = WebAppParser.stripPrefix(rootPath, "/");
        rootPath = WebAppParser.stripSuffix(rootPath, "/");
        rootPath = rootPath.trim();
        return rootPath;
    }

    private static String stripPrefix(String value, String prefix) {
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    private static String stripSuffix(String value, String suffix) {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    private static List<String> extractVirtualHostList(Bundle bundle) {
        LinkedList<String> virtualHostList = new LinkedList<String>();
        String virtualHostListAsString = ManifestUtil.getHeader(bundle, "Web-VirtualHosts");
        if (virtualHostListAsString != null && virtualHostListAsString.length() > 0) {
            String[] virtualHostArray;
            for (String virtualHost : virtualHostArray = virtualHostListAsString.split(",")) {
                virtualHostList.add(virtualHost.trim());
            }
        }
        return virtualHostList;
    }

    private static List<String> extractConnectorList(Bundle bundle) {
        LinkedList<String> connectorList = new LinkedList<String>();
        String connectorListAsString = ManifestUtil.getHeader(bundle, "Web-Connectors");
        if (connectorListAsString != null && connectorListAsString.length() > 0) {
            String[] virtualHostArray;
            for (String virtualHost : virtualHostArray = connectorListAsString.split(",")) {
                connectorList.add(virtualHost.trim());
            }
        }
        return connectorList;
    }

    public static Boolean canSeeClass(Bundle bundle, Class<?> clazz) {
        try {
            return bundle.loadClass(clazz.getName()) == clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static boolean isJettyWebXml(URL url) {
        String path = url.getPath();
        boolean match = (path = path.substring(path.lastIndexOf(47) + 1)).matches("jetty[0-9]?-web\\.xml");
        if (match) {
            return match;
        }
        match = path.matches("web-jetty\\.xml");
        return match;
    }
}

