/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.core;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.ops4j.lang.NullArgumentException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleClassLoader
extends ClassLoader
implements BundleReference {
    private static final EmptyEnumeration<URL> EMPTY_URL_ENUMERATION = new EmptyEnumeration();
    private final Bundle m_bundle;

    public static BundleClassLoader newPriviledged(Bundle bundle) {
        return BundleClassLoader.newPriviledged(bundle, null);
    }

    public static BundleClassLoader newPriviledged(final Bundle bundle, final ClassLoader parent) {
        return AccessController.doPrivileged(new PrivilegedAction<BundleClassLoader>(){

            @Override
            public BundleClassLoader run() {
                return new BundleClassLoader(bundle, parent);
            }
        });
    }

    public BundleClassLoader(Bundle bundle) {
        this(bundle, null);
    }

    public BundleClassLoader(Bundle bundle, ClassLoader parent) {
        super(parent);
        NullArgumentException.validateNotNull(bundle, "Bundle");
        this.m_bundle = bundle;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    @Override
    public URL getResource(String name) {
        if (this.getParent() != null) {
            return super.getResource(name);
        }
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.getParent() != null) {
            return super.getResources(name);
        }
        return this.findResources(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.m_bundle.loadClass(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.getParent() != null) {
            return super.loadClass(name, resolve);
        }
        Class<?> classToLoad = this.findClass(name);
        if (resolve) {
            this.resolveClass(classToLoad);
        }
        return classToLoad;
    }

    @Override
    protected URL findResource(String name) {
        return this.m_bundle.getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration resources = this.m_bundle.getResources(name);
        if (resources == null) {
            return EMPTY_URL_ENUMERATION;
        }
        return resources;
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("bundle=").append(this.m_bundle).append(",parent=").append(this.getParent()).append("}").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleClassLoader that = (BundleClassLoader)o;
        if (this.m_bundle != null ? !this.m_bundle.equals(that.m_bundle) : that.m_bundle != null) {
            return false;
        }
        return !(this.getParent() != null ? !this.getParent().equals(that.getParent()) : that.getParent() != null);
    }

    public int hashCode() {
        return (this.m_bundle != null ? this.m_bundle.hashCode() : 0) * 37 + (this.getParent() != null ? this.getParent().hashCode() : 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyEnumeration<T>
    implements Enumeration<T> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public T nextElement() {
            throw new NoSuchElementException();
        }
    }
}

