/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.nio2.Nio2Acceptor;
import org.apache.sshd.common.io.nio2.Nio2Connector;
import org.apache.sshd.common.util.CloseableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nio2ServiceFactory
implements IoServiceFactory {
    private final Logger logger = LoggerFactory.getLogger(Nio2ServiceFactory.class);
    private final FactoryManager manager;
    private final AsynchronousChannelGroup group;

    public Nio2ServiceFactory(FactoryManager manager) {
        this.manager = manager;
        try {
            ExecutorService executor = Executors.newFixedThreadPool(this.getNioWorkers());
            ((ThreadPoolExecutor)executor).setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            this.group = AsynchronousChannelGroup.withThreadPool(executor);
        }
        catch (IOException e) {
            throw new RuntimeSshException(e);
        }
    }

    public IoConnector createConnector(IoHandler handler) {
        return new Nio2Connector(this.manager, handler, this.group);
    }

    public IoAcceptor createAcceptor(IoHandler handler) {
        return new Nio2Acceptor(this.manager, handler, this.group);
    }

    public CloseFuture close(boolean immediately) {
        try {
            this.group.shutdownNow();
            this.group.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.debug("Exception caught while closing channel group", (Throwable)e);
        }
        return CloseableUtils.closed();
    }

    public int getNioWorkers() {
        int nb;
        String nioWorkers = this.manager.getProperties().get("nio-workers");
        if (nioWorkers != null && nioWorkers.length() > 0 && (nb = Integer.parseInt(nioWorkers)) > 0) {
            return nb;
        }
        return FactoryManager.DEFAULT_NIO_WORKERS;
    }
}

