/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.resolver;

import io.fabric8.agent.resolver.IdentityCapability;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ResourceImpl
implements Resource {
    private final List<Capability> m_caps = new ArrayList<Capability>();
    private final List<Requirement> m_reqs;

    public ResourceImpl(String name, Version version) {
        this(name, "osgi.bundle", version);
    }

    public ResourceImpl(String name, String type, Version version) {
        this.m_caps.add(0, new IdentityCapability(this, name, type, version));
        this.m_reqs = new ArrayList<Requirement>();
    }

    public void addCapability(Capability capability) {
        assert (capability.getResource() == this);
        this.m_caps.add(capability);
    }

    public void addCapabilities(Iterable<? extends Capability> capabilities) {
        for (Capability capability : capabilities) {
            this.addCapability(capability);
        }
    }

    public void addRequirement(Requirement requirement) {
        assert (requirement.getResource() == this);
        this.m_reqs.add(requirement);
    }

    public void addRequirements(Iterable<? extends Requirement> requirements) {
        for (Requirement requirement : requirements) {
            this.addRequirement(requirement);
        }
    }

    public List<Capability> getCapabilities(String namespace) {
        List<Capability> result = this.m_caps;
        if (namespace != null) {
            result = new ArrayList<Capability>();
            for (Capability cap : this.m_caps) {
                if (!cap.getNamespace().equals(namespace)) continue;
                result.add(cap);
            }
        }
        return result;
    }

    public List<Requirement> getRequirements(String namespace) {
        List<Requirement> result = this.m_reqs;
        if (namespace != null) {
            result = new ArrayList<Requirement>();
            for (Requirement req : this.m_reqs) {
                if (!req.getNamespace().equals(namespace)) continue;
                result.add(req);
            }
        }
        return result;
    }

    public String toString() {
        Capability cap = this.getCapabilities("osgi.identity").get(0);
        return cap.getAttributes().get("osgi.identity") + "/" + cap.getAttributes().get("version");
    }
}

