/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.internal;

import io.fabric8.fab.osgi.FabDeploymentListener;
import io.fabric8.fab.osgi.FabResolverFactory;
import io.fabric8.fab.osgi.FabURLHandler;
import io.fabric8.fab.osgi.internal.FabResolverFactoryImpl;
import io.fabric8.fab.osgi.internal.OsgiModuleRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Activator instance;
    private BundleContext bundleContext;
    private ServiceTracker<ConfigurationAdmin, ConfigurationAdmin> configAdminTracker;
    private final List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();

    public static Activator getInstance() {
        return instance;
    }

    public static BundleContext getInstanceBundleContext() {
        Activator activator = Activator.getInstance();
        if (activator != null) {
            return activator.getBundleContext();
        }
        return null;
    }

    public Activator() {
        instance = this;
    }

    public void start(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.configAdminTracker = new ServiceTracker<ConfigurationAdmin, ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class, null){

            public ConfigurationAdmin addingService(ServiceReference<ConfigurationAdmin> reference) {
                ConfigurationAdmin ca = (ConfigurationAdmin)super.addingService(reference);
                Activator.this.bindConfigAdmin(ca);
                return ca;
            }

            public void removedService(ServiceReference<ConfigurationAdmin> reference, ConfigurationAdmin service) {
                Activator.this.unbindConfigAdmin();
                super.removedService(reference, (Object)service);
            }
        };
        this.configAdminTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.configAdminTracker.close();
    }

    protected void bindConfigAdmin(ConfigurationAdmin configAdmin) {
        File data = new File(System.getProperty("karaf.data", "."));
        OsgiModuleRegistry registry = new OsgiModuleRegistry();
        registry.setDirectory(new File(data, "fab-module-registry"));
        registry.setConfigurationAdmin(configAdmin);
        registry.setPid("io.fabric8.fab.osgi.registry");
        registry.load();
        final FabResolverFactoryImpl factory = new FabResolverFactoryImpl();
        factory.setRegistry(registry);
        factory.setBundleContext(this.bundleContext);
        factory.setConfigurationAdmin(configAdmin);
        this.registerFabResolverFactory(factory);
        ServiceTracker<FeaturesService, FeaturesService> featuresServiceTracker = new ServiceTracker<FeaturesService, FeaturesService>(this.bundleContext, FeaturesService.class, null){

            public FeaturesService addingService(ServiceReference<FeaturesService> reference) {
                FeaturesService fs = (FeaturesService)super.addingService(reference);
                factory.setFeaturesService(fs);
                return fs;
            }

            public void removedService(ServiceReference<FeaturesService> reference, FeaturesService service) {
                factory.setFeaturesService(null);
                super.removedService(reference, (Object)service);
            }
        };
        featuresServiceTracker.open();
        FabURLHandler handler = new FabURLHandler();
        handler.setFabResolverFactory(factory);
        handler.setServiceProvider(factory);
        this.registerURLHandler(handler);
        this.registerFabDeploymentListener(new FabDeploymentListener());
    }

    protected void unbindConfigAdmin() {
        for (ServiceRegistration registration : this.registrations) {
            if (registration == null) continue;
            registration.unregister();
        }
        this.registrations.clear();
    }

    private void registerURLHandler(FabURLHandler handler) {
        if (this.bundleContext != null && handler != null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("url.handler.protocol", "fab");
            ServiceRegistration registration = this.bundleContext.registerService(URLStreamHandlerService.class, (Object)handler, props);
            this.registrations.add(registration);
        }
    }

    private void registerFabResolverFactory(FabResolverFactoryImpl factory) {
        if (this.bundleContext != null && factory != null) {
            ServiceRegistration registration = this.bundleContext.registerService(FabResolverFactory.class, (Object)factory, null);
            this.registrations.add(registration);
        }
    }

    private void registerFabDeploymentListener(FabDeploymentListener listener) {
        if (this.bundleContext != null && listener != null) {
            Hashtable<String, Integer> props = new Hashtable<String, Integer>();
            props.put("service.ranking", 1);
            ServiceRegistration registration = this.bundleContext.registerService(new String[]{ArtifactUrlTransformer.class.getName(), ArtifactListener.class.getName()}, (Object)listener, props);
            this.registrations.add(registration);
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }
}

