/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy.xerial;

import java.io.IOException;
import org.elasticsearch.common.compress.snappy.SnappyCompressedStreamOutput;
import org.elasticsearch.common.compress.snappy.SnappyCompressorContext;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.xerial.snappy.Snappy;

public class XerialSnappyCompressedStreamOutput
extends SnappyCompressedStreamOutput {
    public XerialSnappyCompressedStreamOutput(StreamOutput out, SnappyCompressorContext context) throws IOException {
        super(out, context);
    }

    @Override
    protected void compress(byte[] data, int offset, int len, StreamOutput out) throws IOException {
        int compressedLength = Snappy.rawCompress((Object)data, (int)offset, (int)len, (byte[])this.compressedBuffer, (int)0);
        if (compressedLength >= len - len / 8) {
            out.writeBoolean(false);
            out.writeVInt(len);
            out.writeBytes(data, offset, len);
        } else {
            out.writeBoolean(true);
            out.writeVInt(compressedLength);
            out.writeBytes(this.compressedBuffer, 0, compressedLength);
        }
    }
}

